<?php

namespace App\Http\Controllers\Admin;

use App\Models\Review;
use App\Models\Service;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Influencer;

class ManageReviewController extends Controller
{
    public function services(Request $request) {
        $pageTitle = 'Service Review List';
        $reviews   = Review::where('service_id', '!=', 0);
        $reviews = $reviews->latest()->with('user', 'service', 'influencer')->latest()->paginate(getPaginate());
        return view('admin.reviews.services', compact('pageTitle', 'reviews'));
    }

    public function serviceReviewDelete($id) {

        $review = Review::findOrFail($id);
        $service  = Service::approved()->where('id', $review->service_id)->with('reviews')->firstOrFail();
        $review->delete();

        $reviews = $service->reviews;
        $reviewCount = $reviews->count();

        if($reviewCount > 0) {
            $totalRating = $reviews->sum('star');
            $newAverageRating = $totalRating / $reviewCount;
        } else {
            $newAverageRating = 0;
        }

        $service->total_review = $reviewCount;
        $service->rating = $newAverageRating;
        $service->save();

        $notify[] = ['success', 'Review removed successfully'];
        return back()->withNotify($notify);
    }

    public function influencers(Request $request) {

        $pageTitle = 'Influencer Review List';
        $reviews   = Review::where('hiring_id', '!=', 0);
        $reviews = $reviews->latest()->with('user', 'influencer', 'hiring')->latest()->paginate(getPaginate());
        return view('admin.reviews.influencers', compact('pageTitle', 'reviews'));
    }

    public function influencerReviewDelete($id) {

        $review = Review::findOrFail($id);
        $influencer = Influencer::with('reviews')->findOrFail($review->influencer_id);

        $review->delete();

        $reviews = $influencer->reviews;
        $reviewCount = $reviews->count();

        if($reviewCount > 0) {
            $totalRating = $reviews->sum('star');
            $newAverageRating = $totalRating / $reviewCount;
        } else {
            $newAverageRating = 0;
        }

        $influencer->total_review = $reviewCount;
        $influencer->rating = $newAverageRating;
        $influencer->save();

        $notify[] = ['success', 'Review removed successfully'];
        return back()->withNotify($notify);
    }


}
