<?php

namespace App\Http\Controllers\Admin;

use App\Models\Tag;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ManageTagController extends Controller
{
    public function index(){
        $pageTitle = "Tag lists";
        $tags  =  Tag::latest()->paginate(getPaginate());
        return view('admin.tag.index',compact('pageTitle','tags'));
    }

    public function delete(Request $request){

        $tag = Tag::findOrFail($request->id);
        $tag->serviceTag->each->delete();
        $tag->delete();
        
        $notify[] = ['success', 'Tag has been deleted successfully'];
        return back()->withNotify($notify);
    }
}
