<?php

namespace App\Http\Controllers;
use Carbon\Carbon;
use App\Models\Page;
use App\Models\Review;
use App\Models\Service;
use App\Models\Category;
use App\Models\Frontend;
use App\Models\Language;
use App\Models\Influencer;
use App\Models\ServiceTag;
use App\Models\Subscriber;
use Illuminate\Http\Request;
use App\Models\SupportTicket;
use App\Models\SupportMessage;
use App\Models\AdminNotification;
use App\Models\GeneralSetting;
use App\Models\InfluencerCategory;
use Illuminate\Support\Facades\Cookie;

class SiteController extends Controller
{
    public function index(){

        // demo homepart
        $template = @$_GET['template'];
        if ($template) {

            session()->put('template', $template);
            $general = GeneralSetting::first();
            $general->homepage = session('template');
            $general->save();
        }
        // end demo homepart

        $pageTitle = 'Home';
        $general = GeneralSetting::first();
        $sections = Page::where('tempname',$this->activeTemplate)->where('slug','/')->first();
        $influencers = Influencer::active()->orderBy('completed_order', 'desc')->paginate(getPaginate());
        return view($this->activeTemplate . 'home', compact('pageTitle','sections','influencers','general'));
    }

    public function pages($slug)
    {
        $page = Page::where('tempname',$this->activeTemplate)->where('slug',$slug)->firstOrFail();
        $pageTitle = $page->name;
        $sections = $page->secs;
        return view($this->activeTemplate . 'pages', compact('pageTitle','sections'));
    }

    public function contact()
    {
        $pageTitle = "Contact Us";
        return view($this->activeTemplate . 'contact',compact('pageTitle'));
    }

    public function contactSubmit(Request $request)
    {
        $this->validate($request, [
            'name' => 'required',
            'email' => 'required',
            'subject' => 'required|string|max:255',
            'message' => 'required',
        ]);

        if(!verifyCaptcha()){
            $notify[] = ['error','Invalid captcha provided'];
            return back()->withNotify($notify);
        }

        $request->session()->regenerateToken();

        $random = getNumber();

        $ticket = new SupportTicket();
        $ticket->user_id = auth()->id() ?? 0;
        $ticket->name = $request->name;
        $ticket->email = $request->email;
        $ticket->priority = 2;


        $ticket->ticket = $random;
        $ticket->subject = $request->subject;
        $ticket->last_reply = Carbon::now();
        $ticket->status = 0;
        $ticket->save();

        $adminNotification = new AdminNotification();
        $adminNotification->user_id = auth()->user() ? auth()->user()->id : 0;
        $adminNotification->title = 'A new support ticket has opened ';
        $adminNotification->click_url = urlPath('admin.ticket.view',$ticket->id);
        $adminNotification->save();

        $message = new SupportMessage();
        $message->support_ticket_id = $ticket->id;
        $message->message = $request->message;
        $message->save();

        $notify[] = ['success', 'Ticket created successfully!'];

        return to_route('ticket.view', [$ticket->ticket])->withNotify($notify);
    }

    public function policyPages($slug,$id)
    {
        $policy = Frontend::where('id',$id)->where('data_keys','policy_pages.element')->firstOrFail();
        $pageTitle = $policy->data_values->title;
        return view($this->activeTemplate.'policy',compact('policy','pageTitle'));
    }

    public function changeLanguage($lang = null)
    {
        $language = Language::where('code', $lang)->first();
        if (!$language) $lang = 'en';
        session()->put('lang', $lang);
        return back();
    }

    public function blog(){
        $pageTitle = 'Blogs';
        $sections = Page::where('tempname',$this->activeTemplate)->where('slug','blog')->firstOrFail();
        $blogs = Frontend::where('data_keys','blog.element')->orderBy('id','desc')->paginate(getPaginate());
        return view($this->activeTemplate.'blog',compact('sections','blogs','pageTitle'));
    }

    public function blogDetails($slug,$id){
        $blog = Frontend::where('id',$id)->where('data_keys','blog.element')->firstOrFail();
        $pageTitle = 'Blog Details';
        $latests = Frontend::where('data_keys','blog.element')->orderBy('id','desc')->limit(5)->get();
        return view($this->activeTemplate.'blog_details',compact('blog','pageTitle','latests'));
    }

    public function cookieAccept(){
        $general = gs();
        Cookie::queue('gdpr_cookie',$general->site_name , 43200);
        return back();
    }

    public function cookiePolicy(){
        $pageTitle = 'Cookie Policy';
        $cookie = Frontend::where('data_keys','cookie.data')->first();
        return view($this->activeTemplate.'cookie',compact('pageTitle','cookie'));
    }

    public function placeholderImage($size = null){
        $imgWidth = explode('x',$size)[0];
        $imgHeight = explode('x',$size)[1];
        $text = $imgWidth . '×' . $imgHeight;
        $fontFile = realpath('assets/font') . DIRECTORY_SEPARATOR . 'RobotoMono-Regular.ttf';
        $fontSize = round(($imgWidth - 50) / 8);
        if ($fontSize <= 9) {
            $fontSize = 9;
        }
        if($imgHeight < 100 && $fontSize > 30){
            $fontSize = 30;
        }

        $image     = imagecreatetruecolor($imgWidth, $imgHeight);
        $colorFill = imagecolorallocate($image, 255, 255, 255);
        $bgFill    = imagecolorallocate($image, 28, 35, 47);
        imagefill($image, 0, 0, $bgFill);
        $textBox = imagettfbbox($fontSize, 0, $fontFile, $text);
        $textWidth  = abs($textBox[4] - $textBox[0]);
        $textHeight = abs($textBox[5] - $textBox[1]);
        $textX      = ($imgWidth - $textWidth) / 2;
        $textY      = ($imgHeight + $textHeight) / 2;
        header('Content-Type: image/jpeg');
        imagettftext($image, $fontSize, 0, $textX, $textY, $colorFill, $fontFile, $text);
        imagejpeg($image);
        imagedestroy($image);
    }

    public function subscribe(Request $request){

        $request->validate([
            'email'=>'required|unique:subscribers',
        ]);

        $subscribe = new Subscriber();
        $subscribe->email = $request->email;
        $subscribe->save();

        $notify[] = ['success','You have successfully subscribed to the Newsletter'];
        return back()->withNotify($notify);

    }

    public function influencers(Request $request) {
        $pageTitle   = 'Influencers';
        $influencers = Influencer::active()->orderBy('completed_order', 'desc')->paginate(getPaginate());
        return view($this->activeTemplate . 'influencers', compact('influencers', 'pageTitle'));
    }

    public function influencerProfile($name, $id) {

        $influencer = Influencer::active()
            ->with('education', 'qualification', 'services', 'services.category','services.wishlists', 'services.influencer', 'reviews.user', 'hirings')
            ->findOrFail($id);

        $pageTitle = $influencer->fullname;
        $hirings = $influencer->hirings;

        $reviews = collect();

        foreach ($hirings as $hiring) {
            $reviews = $reviews->merge(
                Review::where('influencer_id', $id)
                    ->where('hiring_id', $hiring->id)
                    ->with('user')
                    ->latest()
                    ->get()
            );
        }

        return view($this->activeTemplate . 'influencer.profile', compact('pageTitle', 'influencer', 'reviews'));
    }

    public function services() {
        $pageTitle   = 'Services';
        $services    = Service::with('influencer', 'category','wishlists')->approved()->latest()->paginate(getPaginate());
        return view($this->activeTemplate .'services.service', compact('services', 'pageTitle'));
    }

    public function serviceDetails($slug, $id) {

        $service         = Service::approved()->where('id', $id)->with('category', 'influencer.socialLink','tags','reviews','reviews.user')->firstOrFail();
        $pageTitle       = 'Service Details';
        return view($this->activeTemplate .'services.detail', compact('service', 'pageTitle'));
    }

    public function influencerByCategory(Request $request, $id, $name) {

        $category =  Category::findOrFail($id);
        $pageTitle    = $category->name;
        $influencerId = InfluencerCategory::where('category_id', $id)->select('influencer_id')->get();
        $influencers  = Influencer::active()->whereIn('id', $influencerId)->latest()->paginate(getPaginate());
        return view($this->activeTemplate . 'influencers', compact('influencers', 'pageTitle'));
    }

    public function searchInfluencer(Request $request)
    {
        $pageTitle = "Search Influencer";

        $influencers = Influencer::active()->orderBy('completed_order', 'desc');

        if ($request->filled('search')) {
            $search = $request->search;
            $influencers->where(function ($query) use ($search) {
                $query->where('firstname', 'LIKE', "%$search%")
                    ->orWhere('lastname', 'LIKE', "%$search%")
                    ->orWhere('username', 'LIKE', "%$search%")
                    ->orWhere('profession', 'LIKE', "%$search%");
            });
        }

        if ($request->filled('country')) {
            $influencers->whereJsonContains('address', ['country' => $request->country]);
        }

        $influencers = $influencers->with('socialLink')->paginate(getPaginate());

        return view($this->activeTemplate . 'influencers', compact('influencers', 'pageTitle'));
    }

    public function serviceByTag(Request $request, $id, $name) {

        $pageTitle = 'Service - ' . $name;
        $serviceId = collect(ServiceTag::where('tag_id', $id)->pluck('service_id'))->toArray();
        $services    = Service::with('influencer', 'category','wishlists')->whereIn('id', $serviceId)->approved()->latest()->paginate(getPaginate());
        $sections = Page::where('tempname', $this->activeTemplate)->where('slug', 'service')->first();
        return view($this->activeTemplate . 'services.service', compact('services', 'pageTitle', 'id'));
    }

    public function influencerFilter(Request $request){
        $query = Influencer::active();

        if ($request->categoryId) {
            $influencerId = InfluencerCategory::where('category_id', $request->categoryId)->select('influencer_id')->get();
            $influencers  = $query->whereIn('id', $influencerId);
        }

        if ($request->searchValue) {

            $search  = $request->searchValue;
             $query->where(function ($query) use ($search) {
                $query->where('firstname', "LIKE", "%$search%")
                    ->orWhere('lastname', 'LIKE', "%%$search")
                    ->orWhere('username', 'LIKE', "%$search%")
                    ->orWhere('profession', 'LIKE', "%$search%");
            });
        }

        if ($request->star) {
            $query->where('rating', '>=', $request->star);
        }

        if ($request->topRated =="top_rated") {
            $query->where('completed_order', '>', 0)->orderBy('completed_order', 'desc');
        }

        if ($request->latest == 'latest') {
            $query->where('completed_order', '>', 0)->latest();
        }

        $influencers = $query->with('socialLink')->orderBy('completed_order', 'desc')->paginate(getPaginate());
        $view = view($this->activeTemplate . 'components.influencer.list', compact('influencers'))->render();
        return response()->json([
            'html' => $view
        ]);


    }

    public function serviceFilter(Request $request){

        $priceMinMaxValue = $request->priceMinMaxValue;
        $priceMin = $priceMinMaxValue['priceMin'];
        $priceMax = $priceMinMaxValue['priceMax'];
        $query = Service::where('status',1);

        if ($request->categoryId) {
            $ab = $query->where('category_id', $request->categoryId)->get();

        }
        if ($priceMin !=0 && $priceMax !=0) {
            $query->whereBetween('price', [$priceMin, $priceMax]);
        }

        if ($request->searchValue) {
            $search  = $request->searchValue;
             $query->where(function ($q) use ($search) {
                $q->where('title', 'LIKE', '%' . $search . '%')->orWhere('description', 'LIKE', '%' . $search . '%');
            })->orWhereHas('category', function ($category) use ($search) {
                $category->where('name', 'like', "%$search%");
            });
        }

        if ($request->star) {
            $query->where('rating', '>=', $request->star);
        }


        $services =  $query->latest()->with('influencer', 'category','wishlists')->paginate(getPaginate());
        $view = view($this->activeTemplate .'components.service.list', compact('services'))->render();
        return response()->json([
            'html' => $view
        ]);


    }


}
