<?php

namespace App\Http\Controllers\User;

use App\Models\Order;
use App\Models\Hiring;
use App\Models\Review;
use App\Models\Service;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class ReviewController extends Controller
{
    public function storeServiceReview(Request $request, $id) {

        $this->validation($request->all())->validate();

        $user = auth()->user();
        $service = Service::findOrFail($id);

        $existingReview = Review::where('user_id', $user->id)
        ->where('service_id', $service->id)
        ->first();

        if ($existingReview) {
            $notify[] = ['error', 'You have already submitted a review for this service'];
            return back()->withNotify($notify);
        }

        $isOrder = Order::where('user_id', $user->id)
            ->where('service_id', $service->id)
            ->where('payment_status', 1)->where('status', 1)
            ->first();

        if (!$isOrder) {
            $notify[]= ['error', 'Please order this service first before reviewing it'];
            return back()->withNotify($notify);
        }

        $review = new Review();
        $review->user_id = $user->id;
        $review->influencer_id = $service->influencer_id;
        $review->hiring_id = 0;
        $review->service_id = $service->id;
        $review->star  = $request->star;
        $review->review  = $request->review;
        $review->save();

        if($review->save()){
            $reviews = $service->reviews()->get();
            $reviewCount = $reviews->count();
            $totalRating = $reviews->sum('star');
            $newAverageRating = $totalRating / $reviewCount;

            $service->total_review = $reviewCount;
            $service->rating = $newAverageRating;
            $service->save();
        }

        $notify[] = ['success','Review submitted successfully'];
        return back()->withNotify($notify);
    }

    public function reviewInfluencer($id) {
        $pageTitle = 'Add Review';
        $hiring    = Hiring::findOrFail($id);
        return view($this->activeTemplate . 'user.review.influencer_review', compact('pageTitle', 'hiring'));
    }

    public function storeHiringReview(Request $request) {

        $this->validation($request->all())->validate();

        $user = auth()->user();


        $existingReview = Review::where('user_id', $user->id)
        ->where('hiring_id',$request->hiring_id)
        ->first();

        if ($existingReview) {
            $notify[] = ['error', 'You have already submitted a review for this influencer'];
            return back()->withNotify($notify);
        }

        $isHiring = Hiring::where('user_id', $user->id)
            ->where('id', $request->hiring_id)
            ->where('payment_status', 1)->where('status', 1)
            ->first();

        $influencer = $isHiring->influencer;

        if (!$isHiring) {
            $notify[]= ['error', 'Please hired this influencer first before reviewing it'];
            return back()->withNotify($notify);
        }

        $review = new Review();
        $review->user_id = $user->id;
        $review->influencer_id =$isHiring->influencer_id;
        $review->hiring_id = $isHiring->id;
        $review->service_id = 0;
        $review->star  = $request->star;
        $review->review  = $request->review;
        $review->save();

        if($review->save()){
            $reviews = $influencer->reviews()->get();
            $reviewCount = $reviews->count();
            $totalRating = $reviews->sum('star');
            $newAverageRating = $totalRating / $reviewCount;

            $influencer->total_review = $reviewCount;
            $influencer->rating = $newAverageRating;
            $influencer->save();
        }

        $notify[] = ['success','Review submitted successfully'];
        return back()->withNotify($notify);
    }

    protected function validation(array $data) {
        $validate = Validator::make($data, [
            'star'   => 'required|integer|min:1|max:5',
            'review' => 'required|string',
        ]);
        return $validate;
    }

}
