<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;


    public function service(){
        return $this->hasMany(Service::class,'category_id');
    }

    public function influencers()
    {
        return $this->belongsToMany(Influencer::class, 'influencer_categories');
    }

    public function scopeActive($query)
    {
        return $this->where('status', 1);
    }

    public function statusBadge($status){
        $html = '';
        if($this->status == 1){
            $html = '<span class="badge badge--success">'.trans('Active').'</span>';
        }else{
            $html = '<span class="badge badge--warning">'.trans('Inactive').'</span>';
        }

        return $html;
    }
}
