<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;
    protected $casts = [
        'key_points' => 'object',
    ];

    public function influencer(){
        return $this->belongsTo(Influencer::class,'influencer_id');
    }

    public function category(){
        return $this->belongsTo(Category::class,'category_id');
    }

    public function tags()
    {
        return $this->belongsToMany(Tag::class, 'service_tags');
    }

    public function completeOrder(){
        return $this->hasMany(Order::class,'service_id')->where('status',1);
    }

    public function totalOrder(){
        return $this->hasMany(Order::class,'service_id');
    }

    public function wishlists()
    {
        return $this->hasMany(Wishlist::class);
    }

    public function reviews()
    {
        return $this->hasMany(Review::class);
    }

    public function statusBadge($status){
        $html = '';
        if($this->status == 1){
            $html = '<span class="badge badge--success">'.trans('Active').'</span>';
        }else{
            $html = '<span class="badge badge--warning">'.trans('Inactive').'</span>';
        }
        return $html;
    }

    public function scopePending()
    {
        return $this->where('status', 0);
    }

    public function scopeApproved($query)
    {
        return $query->where('status', 1)
        ->whereHas('category', function($query) {
            $query->where('status', 1);
        })
        ->whereHas('influencer', function($query) {
            $query->where('status', 1);
        });

    }

    public function scopeRejected()
    {
        return $this->where('status', 2);
    }

    public function scopeAvailable()
    {
        return $this->whereIn('status', [0,1]);
    }

}
