<?php

namespace App\Providers;

use App\Models\AdminNotification;
use App\Models\Deposit;
use App\Models\Frontend;
use App\Models\Hiring;
use App\Models\Influencer;
use App\Models\Language;
use App\Models\Order;
use App\Models\Service;
use App\Models\SupportTicket;
use App\Models\User;
use App\Models\Withdrawal;
use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(): void
    {
        $general = gs();
        $activeTemplate = activeTemplate();
        $viewShare['general'] = $general;
        $viewShare['activeTemplate'] = $activeTemplate;
        $viewShare['activeTemplateTrue'] = activeTemplate(true);
        $viewShare['language'] = Language::all();
        $viewShare['emptyMessage'] = 'No data';
        view()->share($viewShare);


        view()->composer('admin.components.tabs.user', function ($view) {
            $view->with([
                'bannedUsersCount'           => User::banned()->count(),
                'emailUnverifiedUsersCount' => User::emailUnverified()->count(),
                'mobileUnverifiedUsersCount'   => User::mobileUnverified()->count(),
                'kycUnverifiedUsersCount'   => User::kycUnverified()->count(),
                'kycPendingUsersCount'   => User::kycPending()->count(),
            ]);
        });

        view()->composer('admin.components.tabs.influencer', function ($view) {
            $view->with([
                'bannedInfluencerCount'           => Influencer::banned()->count(),
                'emailUnverifiedInfluencerCount' => Influencer::emailUnverified()->count(),
                'mobileUnverifiedInfluencerCount'   => Influencer::mobileUnverified()->count(),
                'kycUnverifiedInfluencerCount'   => Influencer::kycUnverified()->count(),
                'kycPendingInfluencerCount'   => Influencer::kycPending()->count(),
            ]);
        });

        view()->composer('admin.components.tabs.service', function ($view) {
            $view->with([
                'serviceCount'              => Service::count(),
                'pendingServiceCount'         => Service::pending()->count(),
                'approvedServiceCount'        => Service::approved()->count(),
                'bannedServiceCount'        => Service::rejected()->count(),
            ]);
        });

        view()->composer('admin.components.tabs.order', function ($view) {
            $view->with([
                'orderCount'              => Order::count(),
                'pendingOrderCount'         => Order::pending()->count(),
                'inprogressOrderCount'        => Order::inprogress()->count(),
                'jobDoneOrderCount'        => Order::jobDone()->count(),
                'completedOrderCount'        => Order::completed()->count(),
                'reportedOrderCount'        => Order::reported()->count(),
                'cancelledOrderCount'        => Order::cancelled()->count(),

            ]);
        });

        view()->composer('admin.components.tabs.hiring', function ($view) {
            $view->with([
                'hiringCount'              => Hiring::count(),
                'pendingHiringCount'         => Hiring::pending()->count(),
                'inprogressHiringCount'        => Hiring::inprogress()->count(),
                'jobDoneHiringCount'        => Hiring::jobDone()->count(),
                'completedHiringCount'        => Hiring::completed()->count(),
                'reportedHiringCount'        => Hiring::reported()->count(),
                'cancelledHiringCount'        => Hiring::cancelled()->count(),

            ]);
        });

        view()->composer('admin.components.tabs.deposit', function ($view) {
            $view->with([
                'pendingDepositsCount'    => Deposit::pending()->count(),
            ]);
        });

        view()->composer('admin.components.tabs.withdrawal', function ($view) {
            $view->with([
                'pendingWithdrawCount'    => Withdrawal::pending()->count(),
            ]);
        });

        view()->composer('admin.components.tabs.ticket', function ($view) {
            $view->with([
                'pendingTicketCount'         => SupportTicket::where('user_id', '!=', 0)->where('influencer_id','=',0)->whereIN('status', [0, 2])->count(),
            ]);
        });

        view()->composer('admin.components.tabs.influencer_ticket', function ($view) {
            $view->with([
                'pendingTicketCount'    =>  SupportTicket::where('influencer_id', '!=', 0)->where('user_id','=',0)->whereIN('status', [0, 2])->count(),
            ]);
        });

        view()->composer('admin.components.sidenav', function ($view) {
            $view->with([
                'bannedUsersCount'           => User::banned()->count(),
                'emailUnverifiedUsersCount' => User::emailUnverified()->count(),
                'mobileUnverifiedUsersCount'   => User::mobileUnverified()->count(),

                'bannedInfluencerCount'           => Influencer::banned()->count(),
                'emailUnverifiedInfluencerCount' => Influencer::emailUnverified()->count(),
                'mobileUnverifiedInfluencerCount'   => Influencer::mobileUnverified()->count(),

                'kycUnverifiedUsersCount'   => User::kycUnverified()->count(),
                'kycPendingUsersCount'   => User::kycPending()->count(),
                
                'pendingTicketCount'         => SupportTicket::where('user_id', '!=', 0)->where('influencer_id','=',0)->whereIN('status', [0, 2])->count(),
                'influencerpendingTicketCount'         => SupportTicket::where('influencer_id', '!=', 0)->where('user_id','=',0)->whereIN('status', [0, 2])->count(),
                'pendingDepositsCount'    => Deposit::pending()->count(),
                'pendingWithdrawCount'    => Withdrawal::pending()->count(),
                'pendingServiceCount'    => Service::pending()->count(),
                'pendingorderCount'    => Order::pending()->count(),
                'pendingHiringCount'    => Hiring::pending()->count(),
            ]);
        });

        view()->composer('admin.components.topnav', function ($view) {
            $view->with([
                'adminNotifications'=>AdminNotification::where('read_status',0)->with('user')->orderBy('id','desc')->take(10)->get(),
                'adminNotificationCount'=>AdminNotification::where('read_status',0)->count(),
            ]);
        });

        view()->composer('includes.seo', function ($view) {
            $seo = Frontend::where('data_keys', 'seo.data')->first();
            $view->with([
                'seo' => $seo ? $seo->data_values : $seo,
            ]);
        });

        if($general->force_ssl){
            \URL::forceScheme('https');
        }


        Paginator::useBootstrapFour();
    }
}
