@extends('admin.layouts.app')
@section('panel')


<div class="d-flex flex-wrap justify-content-end mb-3">
    <div class="d-inline">
        <div class="input-group justify-content-end">
            <input type="text" name="search_table" class="form-control bg--white"
                placeholder="@lang('Search Hiring')...">
            <button class="btn btn--primary input-group-text"><i class="fa fa-search"></i></button>
        </div>
    </div>
</div>
@include('admin.components.tabs.hiring')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th>@lang('Hiring Number')</th>
                                <th>@lang('User')</th>
                                <th>@lang('Influencer')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Delivery Date')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            @forelse($hirings as $key=>$hiring)
                            <tr>
                                <td data-label="@lang('Hiring Number')">{{ $hiring->hiring_no }}</td>
                                <td data-label="@lang('User')">
                                    @if(@$hiring->user)
                                    <a href="{{ route('admin.users.detail', $hiring->user_id) }}">{{ @$hiring->user->username }}</a>
                                    @else
                                    @lang('N/A')
                                    @endif
                                </td>

                                <td data-label="@lang('Influencer')">
                                    @if(@$hiring->influencer)
                                    <a href="{{ route('admin.influencers.detail', $hiring->influencer_id) }}">{{ @$hiring->influencer->username }}</a>
                                    @else
                                    @lang('N/A')
                                    @endif
                                </td>

                                <td data-label="@lang('Amount')">
                                    {{ $general->cur_sym }}{{ showAmount($hiring->amount) }}
                                </td>

                                <td data-label="@lang('Delivery Date')"> {{ showDateTime($hiring->delivery_date) }} </td>
                                <td data-label="@lang('Status')">
                                    @php
                                    echo $hiring->statusBadge($hiring->status);
                                    @endphp
                                </td>
                                <td data-label="@lang('Action')">
                                    <a href="{{ route('admin.hiring.detail', $hiring->id) }}" class="btn btn-sm btn--primary">
                                        <i class="las la-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if ($hirings->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($hirings) }}
            </div>
            @endif
        </div>
    </div>
</div>

@endsection

