@forelse ($conversations as $conversation)
    @if ($conversation->sender == 'admin')
    <div class="single-message admin-message">
        <div class="single-message__content">
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-1">
                <span class="text--primary">@lang('Admin')</span>
                <p class="fs--14px">{{ showDateTime($conversation->created_at) }}</p>
            </div>
            <p class="single-message__details fs--15px">{{ __($conversation->message) }}</p>
        </div>
    </div>
    @else
    <div class="single-message">
        <div class="single-message__content">
            <div class="d-flex flex-wrap align-items-center justify-content-between mb-1">
                <span class="text--primary">{{ __($conversation->sender) }}</span>
                <p class="fs--14px">{{ showDateTime($conversation->created_at) }}</p>
            </div>
            <p class="single-message__details fs--15px">{{ __($conversation->message) }}</p>
        </div>
    </div>
    @endif
@empty
<div class="no-message text-center">
    <h4 class="title fw-normal text--muted">@lang('No message')</h4>
    <i class="far fa-comment-dots text--muted mt-2"></i>
</div>
@endforelse
