@extends('admin.layouts.app')
@section('panel')
<div class="row mb-none-30 justify-content-center">
    <div class="col-xl-4 col-md-6 mb-30">
        <div class="card b-radius--10 overflow-hidden box--shadow1">
            <div class="card-body">
                <h5 class="mb-20 text-muted">@lang('Order Information')</h5>
                <ul class="list-group">

                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold"> @lang('Job Title')</span>
                        <span>{{ $order->title }} </span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold">@lang('order Date')</span>
                        <span>{{ showDateTime($order->created_at) }}</span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold">@lang('Influencer')</span>
                        <span>
                            <a class="fw-bold" href="{{ route('admin.influencers.detail', $order->influencer_id) }}"
                                target="blank">
                                {{@$order->influencer->username }}
                            </a>
                        </span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold">@lang('Client')</span>
                        <span>
                            <a class="text--cyan fw-bold" href="{{ route('admin.users.detail', $order->user_id) }}"
                                target="blank">
                                {{ @$order->user->username }}
                            </a>
                        </span>
                    </li>

                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold">@lang('Amount')</span>
                        <span>{{ showAmount($order->amount) }} {{ $general->cur_text }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold"> @lang('Delivery Date') <i class="fa fa-info-circle text--primary"
                                title="@lang('Estimated delivary date from client end')"></i> </span>
                        <span>{{ showDateTime($order->delivery_date) }}</span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold">@lang('Description')</span>
                        <button class="btn btn-sm btn-outline--primary descriptionBtn"
                            data-description="{{ $order->description }}"><i class="las la-eye"></i></button>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center flex-wrap">
                        <span class="fw-bold">@lang('Status')</span>
                        @php
                         echo $order->statusBadge($order->status);
                        @endphp
                    </li>

                </ul>
            </div>
        </div>
    </div>

    <div class="col-xl-8 col-md-6 mb-30">
        <div class="card b-radius--10 box--shadow1 overflow-hidden">
            <div class="card-body">
                <div class="chat-box" id="message">
                    @include('admin.orders.conversation')
                </div>
                @if ($order->status == 4)
                <div class="message-admin mt-5">
                    <form id="messageForm">
                        @csrf
                        <input type="hidden" name="order_id" value="{{$order->id}}">
                        <div class="input-group mb-3">
                            <input name="message" id="message" class="form-control"
                                placeholder="@lang('Write here')...">
                                <button type="button" class="btn btn--primary msg-submit-btn">@lang('Send Message')</button>
                        </div>
                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-xl-12 col-md-12">
        @if ($order->status == 4)
        <div class="card b-radius--10 box--shadow1 mb-4 overflow-hidden">
            <div class="card-header">
                <h4 class="card-title mb-0 text-center"> <i class="la la-exclamation-triangle text--warning"></i>
                    @lang('Reason of Report')</h4>
            </div>
            <div class="card-body">
                <p class="text--danger">{{ $order->reason }}</p>
            </div>
            <div class="card-footer">
                <p>@lang('Reported by') <a href="{{ route('admin.users.detail', $order->user_id) }}" target="blank">{{
                        @$order->user->username }}</a> (@lang('Client'))</p>
            </div>
        </div>

        <div class="card b-radius--10 box--shadow1 mb-4 mt-4 overflow-hidden">
            <div class="card-header">
                <h4 class="card-title mb-0 text-center">@lang('Take Action')</h4>
            </div>
            <div class="card-body">
                @if ($order->status == 4)
                <div class="d-flex justify-content-center gap-2">
                    <button type="button" class="btn btn-outline--danger confirmationBtn"
                        data-action="{{ route('admin.order.action', [$order->id, 6]) }}" data-question="@lang(" If you
                        click on the 'yes' button, the client will get the balance. which was deducted during his order
                        and the order will be rejected")" data-btn_class="btn btn--primary">
                        <i class="la la-user-astronaut"></i>
                        @lang('In Favour of Client')
                    </button>

                    <button type="button" class="btn btn-outline--success confirmationBtn"
                        data-action="{{ route('admin.order.action', [$order->id, 1]) }}" data-question="@lang(" If you
                        click on the 'yes' button, the balance will be added to the influencer account and the order
                        will be completed.")" data-btn_class="btn btn--primary">
                        <i class="la la-user"></i>
                        @lang('In Favour of Influencer')
                    </button>
                </div>
                @endif
            </div>
        </div>
        @endif
    </div>

</div>

<div id="descriptionModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <p class="description"></p>
            </div>
        </div>
    </div>
</div>
<x-confirmation-modal></x-confirmation-modal>
@endsection

@push('script')
<script>
    (function ($) {
        "use strict";

        $('.descriptionBtn').on('click', function() {
            var modal = $('#descriptionModal');
            modal.find('.modal-title').text(`@lang('Description')`)
            modal.find('.description').html($(this).data('description'));
            modal.modal('show');
        });


        $('.viewReport').on('click', function() {
            var modal = $('#descriptionModal');
            modal.find('.modal-title').text(`@lang('Report Reason')`)
            modal.find('.description').text($(this).data('reason'));
            modal.modal('show');
        });

    })(jQuery);
</script>
@endpush



@if (auth()->guard('admin')->user())
@push('script')
<script src="{{asset($activeTemplateTrue.'js/pusher.min.js')}}"></script>

<script>
    var msgContainer = document.querySelector('.chat-box');
        msgContainer.scrollTop = msgContainer.scrollHeight;

    $('.msg-submit-btn').on('click', function(e) {
        e.preventDefault();

        var message = $("input[name=message]").val();
        var order_id = $("input[name=order_id]").val();
        let message_list_wrapper = $('.chat-box');

        var formData = new FormData();

        formData.append('message', message);
        formData.append('order_id', order_id);

        if (message == '') {
            Toast.fire({
                icon: 'error',
                title: 'Message filed are empty.',
            });
            return;
        }

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            type: "post",
            url: "{{ route('admin.order.conversation.store') }}",
            data: formData,
            cache: false,
            contentType: false,
            processData: false,
            success: function(data) {
                if (data.message != null) {
                    message_list_wrapper.append(`
                    <div class="single-message admin-message">
                        <div class="single-message__content">
                            <div class="d-flex flex-wrap align-items-center justify-content-between mb-1">
                                <span class="text--primary">@lang('Admin')</span>
                                <p class="fs--14px">${data.sendTime}</p>
                            </div>
                            <p class="single-message__details fs--15px">${data.message}</p>
                        </div>
                    </div>
                    `);
                }

                $('input[name=message]').val('');
                var chatBox = $('.chat-box')[0];
                chatBox.scrollTop = chatBox.scrollHeight;
            },
            error: function(data, status, error) {
                $('input[name=message]').val('');
                $.each(data.responseJSON.errors, function(key,item) {
                    Toast.fire({
                        icon: 'error',
                        title: item
                    })
                });
            }
        });
    })

    // Pusher Setup and Credential and Sender - Receiver Function Start
    var app_key = @json(gs()->pusher_credential->app_key);
    var app_cluster = @json(gs()->pusher_credential->app_cluster);
    var my_channel = "{{ auth()->guard('admin')->user()->id }}";

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    var pusher = new Pusher(

        app_key, {
            cluster: app_cluster
        });

    var channel = pusher.subscribe(my_channel);

    channel.bind('App\\Events\\HiringChat', function(data) {

        let message_list_wrapper = $('.chat-box');
        if (data.receiver == my_channel) {
            if (data.message != null) {
                    message_list_wrapper.append(`
                    <div class="single-message">
                        <div class="single-message__content">
                            <div class="d-flex flex-wrap align-items-center justify-content-between mb-1">
                                <span class="text--primary">${data.senderName}</span>
                                <p class="fs--14px">${data.sendTime}</p>
                            </div>
                            <p class="single-message__details fs--15px">${data.message}</p>
                        </div>
                    </div>
                    `);
                }
        }
        var chatBox = $('.chat-box')[0];
        chatBox.scrollTop = chatBox.scrollHeight;
    });

</script>
@endpush
@endif
