@extends('admin.layouts.app')
@section('panel')


<div class="d-flex flex-wrap justify-content-end mb-3">
    <div class="d-inline">
        <div class="input-group justify-content-end">
            <input type="text" name="search_table" class="form-control bg--white"
                placeholder="@lang('Search Order')...">
            <button class="btn btn--primary input-group-text"><i class="fa fa-search"></i></button>
        </div>
    </div>
</div>
@include('admin.components.tabs.order')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th>@lang('Order Number')</th>
                                <th>@lang('User')</th>
                                <th>@lang('Influencer')</th>
                                <th>@lang('Amount')</th>
                                <th>@lang('Delivary')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            @forelse($orders as $order)
                            <tr>
                                <td data-label="@lang('Order Number')">
                                    <span>{{ $order->order_no }}</span>
                                </td>
                                <td data-label="@lang('User')">
                                    @if(@$order->user)
                                    <a href="{{ route('admin.users.detail', $order->user_id) }}" class="text--base">{{ __(@$order->user->username) }}</a>
                                    @else
                                    @lang('N/A')
                                    @endif
                                </td>
                                <td data-label="@lang('Influencer')">
                                    @if(@$order->influencer)
                                    <a href="{{ route('admin.influencers.detail', $order->influencer_id) }}" class="text--base">{{ __(@$order->influencer->username) }}</a>
                                    @else
                                    @lang('N/A')
                                    @endif
                                </td>
                                <td data-label="@lang('Amount')">
                                    {{ __($general->cur_sym) }}{{ showAmount($order->amount) }}
                                </td>
                                <td data-label="@lang('Delivary')">
                                    {{ showDateTime($order->delivery_date) }}
                                </td>
                                <td data-label="@lang('Status')">
                                    @php echo $order->statusBadge($order->status); @endphp
                                </td>

                                <td data-label="@lang('Action')">
                                    <a href="{{ route('admin.order.detail', $order->id) }}" class="btn btn-sm btn-outline--primary">
                                        <i class="las la-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if ($orders->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($orders) }}
            </div>
            @endif
        </div>
    </div>
</div>


@endsection

