
@extends('admin.layouts.app')
@section('panel')

<div class="d-flex flex-wrap justify-content-end mb-3">
    <div class="d-inline">
        <div class="input-group justify-content-end">
            <input type="text" name="search_table" class="form-control bg--white"
                placeholder="@lang('Search Reviews')...">
            <button class="btn btn--primary input-group-text"><i class="fa fa-search"></i></button>
        </div>
    </div>
</div>
@include('admin.components.tabs.reviews')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <thead>
                                <tr>
                                    <th>@lang('Hiring Number')</th>
                                    <th>@lang('Reviewer')</th>
                                    <th>@lang('Influencer')</th>
                                    <th>@lang('Rating')</th>
                                    <th>@lang('Created At')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($reviews as $review)
                                    <tr>
                                        <td data-label="@lang('Hiring Number')">
                                            <span class="fw-bold">
                                                <a href="{{ route('admin.hiring.detail', $review->hiring_id) }}">{{ @$review->hiring->hiring_no }}</a>
                                            </span>
                                        </td>

                                        <td data-label="@lang('Reviewer')">
                                            <a href="{{ route('admin.users.detail', $review->user_id) }}">
                                                {{ @$review->user->username }}
                                            </a>
                                        </td>

                                        <td data-label="@lang('Influencer')">
                                            <a href="{{ route('admin.influencers.detail', $review->influencer_id) }}">
                                                {{ @$review->influencer->username }}
                                            </a>
                                        </td>

                                        <td data-label="@lang('Rating')">
                                            @php
                                            echo showRatings($review->star)
                                            @endphp
                                            ({{$review->star}})
                                        </td>

                                        <td data-label="@lang('Created At')">
                                          {{ showDateTime($review->created_at) }}
                                        </td>

                                        <td data-label="@lang('Action')">
                                            <button type="button" class="btn btn-sm btn--primary viewBtn"
                                                data-review="{{ $review->review }}">
                                                <i class="las la-eye text--shadow"></i>
                                            </button>
                                            <a href="#" class="btn btn-sm btn--danger confirmationBtn" data-action="{{ route('admin.reviews.influencer.delete',$review->id) }}" data-question="@lang('Are you sure remove this review?')" data-btn_class="btn btn--primary">
                                                <i class="las la-trash text--shadow"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                    </table>
                </div>
            </div>
            @if ($reviews->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($reviews) }}
            </div>
            @endif
        </div>
    </div>
</div>

<div class="modal fade" id="viewModal" tabindex="-1" role="dialog" aria-labelledby="viewModalLabel"
aria-hidden="true">
<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">@lang('Review')</h4>
            <button type="button" class="close btn btn-sm btn--danger" data-bs-dismiss="modal" aria-label="Close"><i
                    class="las la-times"></i></button>
        </div>
        <div class="modal-body">
            <p class="modal-detail"></p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn--danger" data-bs-dismiss="modal">@lang('Close')</button>
        </div>
    </div>
</div>
</div>
<x-confirmation-modal></x-confirmation-modal>
@endsection


@push('script')
    <script>
        (function($) {
            "use strict";
            $('.viewBtn').on('click', function() {
                var modal = $('#viewModal');
                modal.find('.modal-detail').text($(this).data('review'));
                modal.modal('show');
            });
        })(jQuery);
    </script>
@endpush

