@extends('admin.layouts.app')
@section('panel')

<div class="d-flex flex-wrap justify-content-end mb-3">
    <div class="d-inline">
        <div class="input-group justify-content-end">
            <input type="text" name="search_table" class="form-control bg--white"
                placeholder="@lang('Search Service')...">
            <button class="btn btn--primary input-group-text"><i class="fa fa-search"></i></button>
        </div>
    </div>
</div>

@include('admin.components.tabs.service')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th>@lang('Title')</th>
                                <th>@lang('Image')</th>
                                <th>@lang('Influencer')</th>
                                <th>@lang('Category')</th>
                                <th>@lang('Order')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody class="list">
                            @forelse($services as $service)
                            <tr>
                                <td data-label="@lang('Title')">
                                    {{__($service->title) }}
                                </td>

                                <td>
                                    <img src="{{ getImage(getFilePath('serviceImage') . '/' . $service->image, getFileSize('serviceImage')) }}"
                                        style="width:80px" class="img-thumbnail">
                                </td>

                                <td data-label="@lang('Influencer')">
                                    @if(@$service->influencer)
                                    <a href="#">{{ @$service->influencer->username }}</a>
                                    @else
                                    @lang('N/A')
                                    @endif
                                </td>

                                <td data-label="@lang('Category')">
                                    {{__(@$service->category->name)}}
                                </td>

                                <td data-label="@lang('Order')">
                                    <span> @lang('Total') : {{ $service->total_order_count }}</span><br>
                                    <span> @lang('Done') : {{ $service->complete_order_count }}</span><br>
                                </td>

                                <td data-label="@lang('Status')">
                                    @php echo $service->statusBadge($service->status); @endphp
                                </td>

                                <td data-label="@lang('Action')">
                                    <a href="{{ route('admin.service.detail', $service->id) }}"
                                        class="btn btn-sm btn--primary">
                                        <i class="las la-eye"></i>
                                    </a>
                                </td>

                            </tr>
                            @empty
                            <tr>
                                <td data-label="@lang('Service Table')" class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            @if ($services->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($services) }}
            </div>
            @endif
        </div>
    </div>
</div>

@endsection
