@foreach ($blogs as $item)
<div class="col-xl-3 col-lg-4 col-md-6 col-12">
    <div class="card">
        <div class="thumb">
            <img src="{{ getImage(getFilePath('blog') .'/'. @$item->data_values->blog_image) }}" alt="@lang('image')">
        </div>
        <div class="content">
            <div class="date">
                <p><i class="fas fa-calendar-week"></i> {{showDateTime($item->created_at)}}</p>
            </div>
            <h5>
                <a href="{{ route('blog.details', ['slug' => slug($item->data_values->title), 'id' => $item->id]) }}">
                    @if (strlen(__(@$item->data_values->title)) > 33)
                    {{ substr(__(@$item->data_values->title), 0, 33) . '...' }}
                    @else
                    {{__(@$item->data_values->title) }}
                    @endif
                </a>
            </h5>
            <p>
                @if (strlen(__(strip_tags(@$item->data_values->description))) > 60)
                {{ substr(__(strip_tags(@$item->data_values->description)), 0, 60) . '...' }}
                @else
                {{ __(strip_tags(@$item->data_values->description)) }}
                @endif
            </p>
            <a href="{{ route('blog.details', ['slug' => slug($item->data_values->title), 'id' => $item->id]) }}" class="blog-link">@lang('Read More')</a>
        </div>
    </div>
</div>
@endforeach
@if(request()->route()->uri != '/')
@if ($blogs->hasPages())
<div class="py-4">
    {{ paginateLinks($blogs) }}
</div>
@endif
@endif
