<div class="sidebar">
    <div class="sidebar__inner">
        <div class="sidebar-top-inner">
            <div class="sidebar__logo">
                <a href="{{route('home')}}" class="sidebar__main-logo">
                    <img src="{{ getImage(getFilePath('logoIcon') . '/logo.png', '?' . time()) }}"
                    alt="{{ config('app.name') }}">
                </a>
                <div class="navbar__left">
                    <button class="navbar__expand">
                        <i class="fa-solid fa-bars-staggered"></i>
                    </button>
                    <button class="sidebar-mobile-menu">
                        <i class="fa-solid fa-bars-staggered"></i>
                    </button>
                </div>
            </div>
            <div class="sidebar__menu-wrapper">
                <ul class="sidebar__menu p-0">
                    <li class="sidebar-menu-item {{ Route::is('user.home') ? 'active' : '' }}">
                        <a href="{{route('user.home')}}">
                            <i class="menu-icon las la-tachometer-alt"></i>
                            <span class="menu-title">@lang('Dashboard')</span>
                        </a>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon las la-users-cog"></i>
                            <span class="menu-title">@lang('Hirings')</span>
                        </a>
                        <ul class="sidebar-submenu {{ isActiveRoute('user.hiring.') ? 'd-block' : '' }}">
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.hiring.index') ? 'active' : '' }}">
                                <a href="{{route('user.hiring.index')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('All Hirings')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.hiring.pending') ? 'active' : '' }}">
                                <a href="{{route('user.hiring.pending')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Pendings')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.hiring.inprogress') ? 'active' : '' }}">
                                <a href="{{route('user.hiring.inprogress')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Processing')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.hiring.completed') ? 'active' : '' }}">
                                <a href="{{route('user.hiring.completed')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Completed')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.hiring.reported') ? 'active' : '' }}">
                                <a href="{{route('user.hiring.reported')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Reported')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.hiring.cancelled') ? 'active' : '' }}">
                                <a href="{{route('user.hiring.cancelled')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Cancelled')</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon las la-list"></i>
                            <span class="menu-title">@lang('Orders')</span>
                        </a>
                        <ul class="sidebar-submenu {{ isActiveRoute('user.order.') ? 'd-block' : '' }}">
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.order.index') ? 'active' : '' }}">
                                <a href="{{route('user.order.index')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('All Orders')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.order.pending') ? 'active' : '' }}">
                                <a href="{{route('user.order.pending')}}" class="nav-link">
                            <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Pending')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.order.inprogress') ? 'active' : '' }}">
                                <a href="{{route('user.order.inprogress')}}" class="nav-link">
                            <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Inprogress')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.order.jobDone') ? 'active' : '' }}">
                                <a href="{{route('user.order.jobDone')}}" class="nav-link">
                            <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Job Done')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.order.completed') ? 'active' : '' }}">
                                <a href="{{route('user.order.completed')}}" class="nav-link">
                            <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Completed')</span>
                                </a>
                            </li>

                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.order.reported') ? 'active' : '' }}">
                                <a href="{{route('user.order.reported')}}" class="nav-link">
                            <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Reported')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.order.cancelled') ? 'active' : '' }}">
                                <a href="{{route('user.order.cancelled')}}" class="nav-link">
                            <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Cancelled')</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon las la-dollar-sign"></i>
                            <span class="menu-title">@lang('Deposit')</span>
                        </a>
                        <ul class="sidebar-submenu {{ isActiveRoute('user.deposit') ? 'd-block' : '' }}">
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.deposit') ? 'active' : '' }}">
                                <a href="{{route('user.deposit')}}" class="nav-link">
                                    <i class="menu-icon las la-plus"></i>
                                    <span class="menu-title">@lang('Deposit Now')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('user.deposit.history') ? 'active' : '' }}">
                                <a href="{{route('user.deposit.history')}}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('Deposit Log')</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item {{ Route::is('user.transactions') ? 'active' : '' }}">
                        <a href="{{route('user.transactions')}}">
                            <i class="menu-icon las la-hand-holding-usd"></i>
                            <span class="menu-title">@lang('Transactions')</span>
                        </a>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon las fas fa-headset"></i>
                            <span class="menu-title">@lang('Support Tickets')</span>
                        </a>
                        <ul class="sidebar-submenu {{ isActiveRoute('ticket') ? 'd-block' : '' }}">
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('ticket') ? 'active' : '' }}">
                                <a href="{{ route('ticket') }}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('My Tickets')</span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item sidebar-menu-sub-menu {{ Route::is('ticket.open') ? 'active' : '' }}">
                                <a href="{{ route('ticket.open') }}" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title">@lang('New Ticket')</span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item {{ Route::is('user.wishlist.list') ? 'active' : '' }}">
                        <a href="{{route('user.wishlist.list')}}">
                            <i class="menu-icon las la-heart"></i>
                            <span class="menu-title">@lang('Wishlists')</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="sidebar-support-box d-grid align-items-center bg-img"
        data-background="{{ asset($activeTemplateTrue . 'images/element/sidebar-bg.png') }}">
        <div class="sidebar-support-icon">
            <i class="fas fa-question-circle"></i>
        </div>
        <div class="sidebar-support-content">
            <h4 class="title">@lang('Need Help')?</h4>
            <p>@lang('Please contact our support').</p>
            <div class="sidebar-support-btn">
                <a href="{{route('ticket.open')}}" class="btn--base w-100 mt-2">@lang('Get Support')</a>
            </div>
        </div>
    </div>
    </div>
</div>
