@php
$categories = App\Models\Category::active()->latest()->get();
$ad = App\Models\Ad::where('status',1)->where('code','ad_ynv8')->first();
@endphp
<div class="col-lg-3 col-md-5 col-12">


    <div class="categories">
        <h6>@lang('Search')</h6>
        <div class="category-list">
            <input type="text" name="search" id="searchValue" placeholder="@lang('Search')..." class="form--control">
        </div>
    </div>

    <div class="categories">
        <h6>@lang('Categories')</h6>
        <div class="category-list">
            @foreach ($categories as $category)
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input type="radio" class="form-check-input filter-by-category" name="category" value="{{ $category->id }}" id="category{{ $category->id }}">
                    <label  for="category{{ $category->id }}" class="form-check-label">{{ __($category->name) }}</label>
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <div class="categories">
        <h6>@lang('Rating')</h6>
        <div class="category-list">
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="5" id="rating-5">
                    <label for="rating-5" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="4" id="rating-4">
                    <label for="rating-4" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="3" id="rating-3">
                    <label for="rating-3" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="2" id="rating-2">
                    <label for="rating-2" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="1" id="rating-1">
                    <label for="rating-1" class="form-check-label">
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="categories">
        <h6>@lang('Sort By')</h6>
        <div class="category-list">
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="top_rated" value="top_rated" type="radio" id="top_rated">
                    <label for="top_rated" class="form-check-label">@lang('Top Rated')</label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="latest" value="latest" type="radio" id="latest">
                    <label for="latest" class="form-check-label">@lang('Latest')</label>
                </div>
            </div>
        </div>
    </div>

    @if($ad)
    <div class="mt-3">
        <div class="adthumb">
            <a class="d-flex mx-auto" href="{{$ad->redirect_url}}">
                <img src="{{ getImage(getFilePath('adImage') . '/' . @$ad->image) }}" alt="image">
            </a>
        </div>
    </div>
    @endif
</div>

@push('script')
<script>
    (function ($) {
        "use strict";
        $("input[type='radio'][name='category']").on('click', function(){
            var categoryId = $(this).val();
            var star ='';
            var topRated='';
            var latest='';
            var searchValue='';

            getFilteredData(categoryId,star,topRated,latest,searchValue)
        });

        $("input[type='radio'][name='star']").on('click', function(){
            var star = $(this).val();
            var categoryId = '';
            var topRated='';
            var latest='';
            var searchValue='';
            getFilteredData(categoryId,star,topRated,latest,searchValue)
        });

        $("input[type='radio'][name='top_rated']").on('click', function(){
            var topRated = $(this).val();
            var star = '';
            var categoryId = '';
            var latest='';
            var searchValue='';
            getFilteredData(categoryId,star,topRated,latest,searchValue)
        });

        $("input[type='radio'][name='latest']").on('click', function(){
            var latest = $(this).val();
            var topRated = '';
            var star = '';
            var categoryId = '';
            var searchValue='';
            getFilteredData(categoryId,star,topRated,latest,searchValue)
        });



        $("#searchValue").on('keyup', function () {
            var searchValue = $(this).val();
            var latest = '';
            var topRated = '';
            var star = '';
            var categoryId = '';
            getFilteredData(categoryId,star,topRated,latest,searchValue)

        });



        function getFilteredData(categoryId,star,topRated,latest,searchValue){

            $.ajax({
                type: "get",
                url: "{{ route('influencer.filtered') }}",
                data:{
                    "categoryId": categoryId,
                    "star": star,
                    "topRated": topRated,
                    "latest": latest,
                    "searchValue": searchValue,
                },
                dataType: "json",
                success: function (response) {
                    if(response.html){
                        $('.main-content').html(response.html);
                    }

                    if(response.error){
                        notify('error', response.error);
                    }
                }
            });
        }

    })(jQuery);
</script>
@endpush

