@php
$ad = App\Models\Ad::where('status',1)->where('code','ad_ynv8')->first();
$categories = App\Models\Category::active()->latest()->get();
@endphp
<div class="col-lg-3 col-md-5 col-12">


    <div class="categories">
        <h6>@lang('Search')</h6>
        <div class="category-list">
           <input type="text" name="search" id="searchValue" placeholder="@lang('Search')..." class="form--control">
        </div>
    </div>

    <div class="categories">
        <h6>@lang('Categories')</h6>
        <div class="category-list">
            @foreach ($categories as $category)
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input type="radio" class="form-check-input filter-by-category" name="category" value="{{ $category->id }}" id="category{{ $category->id }}">
                    <label  for="category{{ $category->id }}" class="form-check-label">{{ __($category->name) }}</label>
                </div>
            </div>
            @endforeach
        </div>
    </div>

    <div class="categories">
        <h6>@lang('Rating')</h6>
        <div class="category-list">
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="5" id="rating-5">
                    <label for="rating-5" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="4" id="rating-4">
                    <label for="rating-4" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="3" id="rating-3">
                    <label for="rating-3" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="2" id="rating-2">
                    <label for="rating-2" class="form-check-label">
                        <i class="las la-star"></i>
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
            <div class="check-item">
                <div class="form--check categories-search mb-2">
                    <input class="form-check-input filter-by-category" name="star" type="radio"
                        value="1" id="rating-1">
                    <label for="rating-1" class="form-check-label">
                        <i class="las la-star"></i>
                    </label>
                </div>
            </div>
        </div>
    </div>

    <div class="categories">
        <h6>@lang('Price')</h6>
        <div>
            <div class="mb-3">
                <input type="number" id="priceMin" class="form--control" placeholder="@lang('Min')">
            </div>
            <div class="mb-3">
                <input type="number" id="priceMax" class="form--control" placeholder="@lang('Max')">
            </div>
        </div>
    </div>

    @if($ad)
    <div class="mt-3">
        <div class="adthumb">
            <a class="d-flex mx-auto" href="{{$ad->redirect_url}}">
                <img src="{{ getImage(getFilePath('adImage') . '/' . @$ad->image) }}" alt="image">
            </a>
        </div>
    </div>
    @endif
</div>

@push('script')
<script>
    (function ($) {
        "use strict";

        var priceMinMaxValue = [];

        $("input[type='radio'][name='category']").on('click', function(){

            var categoryId = $(this).val();
            var star ='';
            var searchValue='';
            var priceMin = 0;
            var priceMax = 0;

            priceMinMaxValue = {
                priceMin: priceMinMaxValue.priceMin ?? priceMin,
                priceMax: priceMinMaxValue.priceMax ?? priceMax
            };
            getFilteredData(categoryId,star,searchValue,priceMinMaxValue)
        });

        $("input[type='radio'][name='star']").on('click', function(){
            var star = $(this).val();
            var categoryId = '';
            var searchValue='';
            var priceMin = 0;
            var priceMax = 0;

            priceMinMaxValue = {
                priceMin: priceMinMaxValue.priceMin ?? priceMin,
                priceMax: priceMinMaxValue.priceMax ?? priceMax
            };

            getFilteredData(categoryId,star,searchValue,priceMinMaxValue)
        });

        $("#searchValue").on('keyup', function () {

            var searchValue = $(this).val();
            var star = '';
            var categoryId = '';
            var priceMin = 0;
            var priceMax = 0;

            priceMinMaxValue = {
                priceMin: priceMinMaxValue.priceMin ?? priceMin,
                priceMax: priceMinMaxValue.priceMax ?? priceMax
            };
            getFilteredData(categoryId,star,searchValue,priceMinMaxValue)

        });


        $("#priceMin").on('keyup', function () {
            var searchValue = '';
            var star = '';
            var categoryId = '';

            var priceMax = 0;
            var priceMin = $("#priceMin").val();

            priceMinMaxValue = {
                priceMin: priceMin,
                priceMax: priceMinMaxValue.priceMax ?? priceMax
            };

            getFilteredData(categoryId,star,searchValue,priceMinMaxValue)

        });

        $("#priceMax").on('keyup', function () {

            var searchValue = '';
            var star = '';
            var categoryId = '';

            var priceMin = 0;
            var priceMax = $("#priceMax").val();

            priceMinMaxValue = {
                    priceMin: priceMinMaxValue.priceMin ?? priceMin,
                    priceMax: priceMax
            };

            getFilteredData(categoryId,star,searchValue,priceMinMaxValue)

        });

        function getFilteredData(categoryId,star,searchValue,priceMinMaxValue){

            $.ajax({
                type: "get",
                url: "{{ route('service.filtered') }}",
                data:{
                    "categoryId": categoryId,
                    "star": star,
                    "searchValue": searchValue,
                    "priceMinMaxValue": priceMinMaxValue,
                },
                dataType: "json",
                success: function (response) {

                    if(response.html){
                        $('.main-content').html(response.html);
                    }

                    if(response.error){
                        notify('error', response.error);
                    }
                }
            });
        }

    })(jQuery);
</script>
@endpush
