@extends($activeTemplate.'layouts.influencer.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="m-0">
            <div class="list-card">
                <div class="row search-dash justify-content-end mb-3">
                    <div class="col-xl-3 col-lg-5 col-md-6 col-10"> <input type="text" class="form--control" name="search_table" placeholder="@lang('Search')...">
                        <i class="las la-search"></i>
                    </div>
                </div>

                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th>@lang('Hiring Number')</th>
                                    <th>@lang('Client')</th>
                                    <th>@lang('Amount')</th>
                                    <th>@lang('Delivary')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($hirings as $hiring)
                                <tr>
                                    <td data-label="@lang('Hiring Number')">{{ $hiring->hiring_no }}</td>
                                    <td data-label="@lang('Client')">
                                        @if(@$hiring->user)
                                         {{@$hiring->user->username}}
                                        @else
                                        @lang('N/A')
                                        @endif
                                    </td>
                                    <td data-label="@lang('Amount')">{{$general->cur_sym}}{{ showAmount($hiring->amount) }}</td>
                                    <td data-label="@lang('Delivary')">{{ showDateTime($hiring->delivery_date) }}</td>
                                    <td data-label="@lang('Status')">
                                        @php
                                        echo $hiring->statusBadge($hiring->status);
                                        @endphp
                                    </td>
                                    <td data-label="@lang('Action')" class="table-dropdown">
                                        <i class="fas fa-ellipsis-v" data-bs-toggle="dropdown"></i>

                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="{{ route('influencer.hiring.detail',$hiring->id) }}">@lang('Details')</a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="{{ route('influencer.hiring.conversation.view',$hiring->id) }}">@lang('Message')</a>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>
                                @empty
                                <td class="text-muted text-center" data-label="@lang('Hiring Table')" colspan="100%">{{__($emptyMessage) }}</td>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-5">
                        @if ($hirings->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($hirings) }}
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    (function ($) {
            "use strict";

            $('.custom-table').css('padding-top', '0px');
            var tr_elements = $('.custom-table tbody tr');

            $(document).on('input', 'input[name=search_table]', function () {
                "use strict";

                var search = $(this).val().toUpperCase();
                var match = tr_elements.filter(function (idx, elem) {
                    return $(elem).text().trim().toUpperCase().indexOf(search) >= 0 ? elem : null;
                }).sort();
                var table_content = $('.custom-table tbody');
                if (match.length == 0) {
                    table_content.html('<tr><td colspan="100%" class="text-center">Data Not Found</td></tr>');
                } else {
                    table_content.html(match);
                }
            });

    })(jQuery);

</script>
@endpush



