@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== influencer-profile Start ==================== -->
<section class="influencer-profile py-80">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-4 col-md-6 col-12">

                <div class="info">
                    <div class="profile">
                        <img src="{{ getImage(getFilePath('influencerProfile').'/'.$influencer->image,getFileSize('influencerProfile')) }}"
                            alt="@lang('Influencer Profile')">
                        <h5>{{__($influencer->fullname)}}</h5>
                        <p>{{__($influencer->profession)}}</p>
                        <p class="text--base">
                            @php
                            echo showRatings($influencer->rating);
                            @endphp
                        </p>
                        @foreach($influencer->socialLink as $item)
                        <div class="d-flex justify-content-center align-items-center mb-2">
                                <a class="social-list__link me-2" href="{{ $item->url }}">
                                    @php echo $item->social_icon; @endphp
                                </a>
                            <span>{{ $item->followers }} @lang('followers')</span>
                        </div>
                        @endforeach
                        <div class="px-3">
                            @if (!authInfluencerId())
                            <a href="{{ route('user.hiring.request', [slug($influencer->username), $influencer->id]) }}"
                                class="btn--base btn--sm mt-2 w-100">@lang('Hire Me')</a>
                            @else
                            <a href="javascript:void(0)" class="btn--base btn--sm mt-2 w-100">@lang('My Profile')</a>
                            @endif
                        </div>

                    </div>
                </div>

                <div class="dec">
                    <div>
                        <h5>@lang('Description')</h5>
                    </div>
                    <div>
                        <p>
                            {{__($influencer->summary?? 'No Summary')}}
                        </p>
                    </div>
                </div>

                @if($influencer->skills)
                <div class="skill">
                    <div>
                        <h5>@lang('Skills')</h5>
                    </div>
                    <div class="d-flex flex-wrap align-items-center">
                        @forelse (@$influencer->skills??[] as $skill)
                        <p>{{__($skill)}}</p>
                        @empty
                        <p>{{__($emptyMessage)}}</p>
                        @endforelse
                    </div>
                </div>
                @endif

                @if($influencer->languages)
                <div class="skill">
                    <div>
                        <h5>@lang('Languages')</h5>
                    </div>
                    <div class="d-flex flex-wrap align-items-center">
                        @foreach (@$influencer->languages as $key => $profiencies)
                        <h6>@lang('Name'): {{ __($key) }}</h6>
                        <div class="d-flex my-2 flex-wrap gap-2">
                            @foreach ($profiencies as $key => $profiency)
                            <span class="me-3 py-1 badge badge--info">
                                {{ keyToTitle($key) }}: {{ $profiency }}
                            </span>
                            @endforeach
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif

                @if(@$influencer->education->count() > 0)
                <div class="skill">
                    <div>
                        <h5>@lang('Education')</h5>
                    </div>
                    <div class="d-flex flex-wrap align-items-center">
                        @foreach ($influencer->education??[] as $education)
                        <span>@lang('Name'): {{__($education->degree) }}</span>
                        <span>@lang('Institude'): {{ __($education->institute) }},{{ $education->country }}</span>
                        <span>@lang('Year'): {{ __($education->start_year) }} -
                            {{ __($education->end_year) }} </span>
                        @endforeach
                    </div>
                </div>
                @endif

                @if ($influencer->qualification->count() > 0)
                <div class="skill">
                    <div>
                        <h5>@lang('Qualifications')</h5>
                    </div>
                    <div class="d-flex flex-wrap align-items-center">
                        @foreach ($influencer->qualification??[] as $qualification)
                        <span>@lang('Cetificate'): {{ __($qualification->certificate) }}</span>
                        <span>@lang('Organization'): {{ __($qualification->organization) }},{{ $qualification->year
                            }}</span>
                        <span>@lang('Summary'): {{ __($qualification->summary) }}</span>
                        @endforeach
                    </div>
                </div>
                @endif

                <div class="skill">
                    <div class="profile-review">
                        <h5>@lang('Client Review')</h5>
                        <div class="customer-review">
                            @if(@$reviews->count() > 0)
                            @forelse (@$reviews as $review)
                            <div class="profile">
                                <img src="{{ getImage(getFilePath('influencerProfile').'/'.@$review->user->image,getFileSize('influencerProfile')) }}"  alt="@lang('user profile')">
                                <div>
                                    <div class="d-flex justify-content-between my-2">
                                        <h6>{{@$review->user->username}}</h6>
                                        <div class="d-flex align-items-center star">
                                            @php
                                            echo showRatings(@$review->star);
                                            @endphp
                                        </div>
                                    </div>
                                    <p>{{ $review->created_at->format('d M Y') }}</p>
                                    <p class="mt-2">{{__($review->review)}}</p>
                                </div>
                            </div>
                            @empty
                            <p>{{__($emptyMessage)}}</p>
                            @endforelse
                            @else
                            <p>{{__($emptyMessage)}}</p>
                            @endif
                        </div>
                    </div>
                </div>
                
            </div>

            <div class="col-lg-8 col-md-6 col-12 services">
                <div class="row gy-4">
                    @forelse (@$influencer->services??[] as $service)
                    <div class="col-xl-4 col-lg-6 col-12">
                        <div class="card">
                            <div class="thumb">
                                <img src="{{getImage(getFilePath('serviceImage').'/'.@$service->image)}}"
                                    alt="@lang('serviceImage')">
                                <div class="tag">
                                    <h6>
                                        @if (strlen(__(@$service->category->name)) >20)
                                        {{ substr(__(@$service->category->name), 0, 20) . '...' }}
                                        @else
                                        {{__(@$service->category->name) }}
                                        @endif
                                    </h6>
                                </div>
                            </div>
                            <div class="content">
                                <a href="{{ route('service.details', [slug($service->title), $service->id]) }}" class="w-100">
                                    <h5>
                                        @if (strlen(__(@$service->title)) > 28)
                                        {{ substr(__(@$service->title), 0, 28) . '...' }}
                                        @else
                                        {{__(@$service->title) }}
                                        @endif
                                    </h5>
                                    <div class="d-flex justify-content-between">
                                        <div class="star">
                                            <h5>
                                                @php
                                                echo showRatings(@$service->rating);
                                                @endphp
                                                <span>({{ $service->total_review ?? 0 }})</span>
                                            </h5>
                                        </div>
                                        <div class="price">
                                            <h5>{{ $general->cur_sym }}{{ showAmount($service->price) }}</h5>
                                        </div>
                                    </div>
                                </a>
                                <div class="profile">
                                    <a href="{{ route('influencer.profile', [slug($service->influencer->username), $service->influencer->id]) }}" class="d-flex">
                                        <img src="{{ getImage(getFilePath('influencerProfile').'/'.@$service->influencer->image,getFileSize('influencerProfile')) }}"
                                            alt="image">
                                        <p>{{__(@$service->influencer->fullname)}}</p>
                                    </a>
                                    <div class="d-flex">
                                        <a href="javascript:void(0)" class="addToWishList" data-id="{{ $service->id }}" onclick="addToWishlist(this)">
                                            @if (auth()->check() && $service->wishlists->where('user_id', auth()->user()->id)->count() > 0)
                                                <i class="fas fa-heart text--base"></i>
                                            @else
                                                <i class="far fa-heart"></i>
                                            @endif
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="d-flex justify-content-center align-items-center nodata_img">
                        <img src="{{ asset($activeTemplateTrue .'images/nodata.png') }}" alt="image">
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ==================== influencer-profile End ==================== -->
@endsection

@push('script')
<script>
   function addToWishlist(element) {

    "use strict"

        var isAddingToWishlist = false;
        var isLoggedIn = {{ Auth::check() ? 'true' : 'false' }};

        if (!isAddingToWishlist && isLoggedIn) {
            isAddingToWishlist = true;
            var propertyId = $(element).data('id');

            $.ajax({
                url: '{{ route('user.wishlist.add') }}',
                type: 'get',
                data: {
                    propertyId: propertyId,
                },
                complete: function() {
                    isAddingToWishlist = false;
                },
                success: function(response) {
                    if (response.hasOwnProperty('message')) {
                        Toast.fire({
                            icon: 'success',
                            title: response.message
                        });
                        var heartIcon = $(element).find('i');
                        heartIcon.removeClass('far fa-heart').addClass('fas fa-heart');
                    } else {
                        Toast.fire({
                            icon: 'warning',
                            title: response.error
                        });
                    }
                },
                error: function(xhr, status, error) {
                    var errorMessage = 'Error occurred while adding the item to the wishlist.';
                    Toast.fire({
                        icon: 'error',
                        title: errorMessage
                    });
                }
            });
        } else {
            var errorMessage = 'Please log in to add items to your wishlist and insure are you client?';
            Toast.fire({
                icon: 'warning',
                title: errorMessage
            });

            isAddingToWishlist = false;
        }
    }
</script>
@endpush
