@extends($activeTemplate.'layouts.influencer.master')
@section('content')
@php
    $categoryId = [];
    foreach (@$user->categories??[] as $category) {
    $categoryId[] = $category->id;
    }
@endphp
<div class="body-wrapper">
    <div class="table-content">
        <div class="row">
            <div class="col-lg-6">
                <div class="dashboard-card-wrap mt-0 has-select2">
                    <form class="register" action="" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row gy-4">
                            <div class="col-sm-12">
                                <div class="drop-file-wrap--">
                                    <div class="dashboard_profile_wrap">
                                        <div class="profile_photo mb-2">
                                            <img src="{{ getImage(getFilePath('influencerProfile').'/'.$user->image,getFileSize('influencerProfile')) }}"  alt="@lang('user profile')">
                                            <div class="photo_upload">
                                                <label for="image"><i class="fas fa-image"></i></label>
                                                <input id="image" type="file" name="image" class="upload_file">
                                            </div>
                                        </div>
                                        <div class="user-info text-center">
                                            <p><span>@lang('Name'):</span> {{__($user->fullname)}}</p>
                                            <p><span>@lang('Email'):</span> {{$user->email}}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="first_name" class="form--label">@lang('First Name')</label>
                                    <div class="input--group">
                                        <input type="text" class="form--control" id="first_name" name="firstname"
                                            value="{{$user->firstname}}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="last_name" class="form--label">@lang('Last Name')</label>
                                    <div class="input--group">
                                        <input type="text" class="form--control" id="last_name" name="lastname"
                                            value="{{$user->lastname}}" required>
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="professional-headline" class="form--label">@lang('Profession')</label>
                                    <input type="text" class="form-control form--control" id="professional-headline" name="profession" value="{{ $user->profession }}">
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group col-sm-12">
                                    <label for="professional-headline" class="form--label">@lang('Category')</label>
                                    <select name="category[]" class="from--control form-control select2-multi-select form-select" multiple>
                                        @foreach (@$categories as $category)
                                            <option value="{{ $category->id }}" @if (in_array($category->id, $categoryId)) selected @endif>{{ __($category->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="email_adress" class="form--label">@lang('E-mail Address')</label>
                                    <div class="input--group">
                                        <input type="text" class="form--control" id="email_adress" value="{{$user->email}}"
                                            readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="zip_code" class="form--label">@lang('Mobile Number')</label>
                                    <div class="input--group">
                                        <input type="text" id="zip_code" class="form--control" name="address"
                                            value="{{@$user->address->address}}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="phone_number" class="form--label">@lang('State')</label>
                                    <div class="input--group">
                                        <input type="text" id="phone_number" class="form--control" name="state"
                                            value="{{@$user->address->state}}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="phone_number" class="form--label">@lang('Zip Code')</label>
                                    <div class="input--group">
                                        <input type="text" id="phone_number" class="form--control" name="zip"
                                            value="{{@$user->address->zip}}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="phone_number" class="form--label">@lang('City')</label>
                                    <div class="input--group">
                                        <input type="text" id="phone_number" class="form--control" name="city"
                                            value="{{@$user->address->city}}">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label for="phone_number" class="form--label">@lang('Country')</label>
                                    <div class="input--group">
                                        <input type="text" id="phone_number" class="form--control"
                                            value="{{@$user->address->country}}" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label for="summary" class="form--label">@lang('Summary')</label>
                                    <textarea name="summary" id="summary" class="form-control form--control">{{ $user->summary }}</textarea>
                                </div>
                            </div>
                            <div class="col-sm-12 text-end">
                                <button type="submit" class="btn btn--base ms-2">
                                    @lang('Submit')
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-6">
                 {{--kill --}}
                <div class="dashboard-card-wrap mt-0 mb-3">
                    <div class="influencer-skill mt-5">
                        <div class="d-flex justify-content-between align-items-center flex-wrap border-none">
                            <h5>@lang('Skills')</h5>
                            <button type="button" class="btn--base btn--sm editSkillbtn border-0"> <i class="la la-edit"></i> @lang('Edit')</button>
                        </div>
                        <div>

                            @if (@$user->skills)
                                @foreach (@$user->skills as $skill)
                                    <div class="justify-content-between badge badge--primary  my-1">
                                        <span>{{__(@$skill) }}</span>
                                    </div>
                                @endforeach
                            @else
                                <div class="justify-content-center noSkill">
                                    <span>@lang('No skill added yet')</span>
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="skill-edit d-none mt-5">
                        <div class="d-flex justify-content-between align-items-center flex-wrap border-none mb-2">
                            <h5>@lang('Skills')</h5>
                            <button type="button" class="btn--base btn--sm skillBtn"> <i class="la la-plus"></i> @lang('Add New')</button>
                        </div>
                        <div>
                            <form action="{{ route('influencer.skill') }}" method="POST">
                                @csrf
                                <div id="skillContainer">
                                    @if (@$user->skills)
                                        @foreach ($user->skills as $skill)
                                            <div class="add-skill d-flex gap-2 mb-2">
                                                <input type="text" name="skills[]" class="form-control form--control" value="{{ $skill }}" required>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="add-skill d-flex gap-2  mb-2">
                                            <input type="text" name="skills[]" class="form-control form--control" placeholder="@lang('Enter your skill')" required>
                                        </div>
                                    @endif
                                </div>
                                <div class="text-end mt-3">
                                    <button type="button" class="btn--base btn--danger btn--sm cancelSkillBtn">@lang('Cancel')</button>
                                    <button class="btn--base btn--sm">@lang('Submit')</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                {{-- end skill --}}

                {{-- language --}}
                <div class="dashboard-card-wrap mt-0 mb-3">
                    <div class="d-flex justify-content-between align-items-center flex-wrap border-none">
                        <h5>@lang('Language')</h5>
                        <button type="button" class="btn--base btn--sm languageBtn"> <i class="la la-plus"></i> @lang('Add New')</button>
                    </div>

                    <div class="row">
                        @if ($user->languages)
                            @foreach (@$user->languages as $key => $profiencies)
                                <div class="col-12">
                                    <div class="education-content py-3">
                                        <div class="d-flex justify-content-between align-items-center mb-2 gap-3">
                                            <h6>@lang('Name'): {{ __($key) }}</h6>
                                            <div class="d-flex gap-sm-2 gap-1">
                                                <button type="button" class="confirmationBtn border-0" data-action="{{ route('influencer.language.remove', $key) }}" data-question="@lang('Are you sure to removed this language?')"><span class="text--danger"><i class="las la-trash"></i>@lang('Delete')</span></button>
                                            </div>

                                        </div>
                                        <div class="d-flex my-2 flex-wrap gap-2">
                                            @foreach ($profiencies as $key => $profiency)
                                                <span class="me-3 py-1 badge badge--info">
                                                   {{ keyToTitle($key) }}: {{ $profiency }}
                                                </span>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="col-12 py-3">
                                <div class="justify-content-center">
                                    <span>@lang('No language added yet')</span>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                {{-- end language --}}

                {{-- social link --}}
                <div class="dashboard-card-wrap mt-0 mb-3">
                    <div class="d-flex justify-content-between align-items-center flex-wrap border-none">
                        <h5>@lang('Social Links')</h5>
                        <button type="button" class="btn--base btn--sm socialBtn"><i class="la la-plus"></i> @lang('Add New')</button>
                    </div>

                    <div>
                        @forelse (@$user->socialLink as $social)
                            <div class="education-content py-3">
                                <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                                    <div class="d-flex flex-wrap">
                                        <span class="text--base me-2">@php  echo $social->social_icon @endphp</span>
                                        <span class="text-break">{{ __($social->url) }}</span>
                                    </div>
                                    <div class="d-flex flex-wrap">
                                        <span>{{__($social->followers) }}</span>
                                        <span class="ms-2">@lang('Followers')</span>
                                    </div>
                                    <div class="d-flex gap-sm-2 gap-1">
                                        <button type="button" class="editSocialBtn border-0" data-url="{{ $social->url }}" data-social_icon="{{ $social->social_icon }}" data-followers="{{ $social->followers }}" data-action="{{ route('influencer.add.socialLink', $social->id) }}"><span class="text--base"><i class="lar la-edit"></i> @lang('Edit')</span></button>
                                        <button type="button" class="confirmationBtn border-0" data-action="{{ route('influencer.remove.socialLink', $social->id) }}" data-question="@lang('Are you sure to removed this social link?')" data-btn_class="btn btn--base btn--md"><span class="text--danger"><i class="las la-trash"></i> @lang('Delete')</span></button>
                                    </div>
                                </div>
                            </div>
                        @empty
                            <div class="justify-content-center py-3">
                                <span>@lang('No social link added yet')</span>
                            </div>
                        @endforelse
                    </div>
                </div>
                {{-- end social link --}}

                {{-- education --}}
                <div class="dashboard-card-wrap mt-0 mb-3">
                    <div class="d-flex justify-content-between align-items-center flex-wrap border-none">
                        <h5>@lang('Education')</h5>
                        <button type="button" class="btn--base btn--sm educationBtn"> <i class="la la-plus"></i> @lang('Add New')</button>
                    </div>

                    <div>
                        @forelse (@$user->education??[] as $education)
                            <div class="education-content py-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h6>{{ __($education->degree) }}</h6>
                                    <div class="d-flex gap-sm-2 gap-1">

                                        <button type="button" class="btn--no-border editEduBtn border-0" data-degree="{{ $education->degree }}" data-institute="{{ $education->institute }}" data-country="{{ $education->country }}" data-start_year="{{ $education->start_year }}" data-end_year="{{ $education->end_year }}" data-action="{{ route('influencer.add.education', $education->id) }}"><span class="text--base"><i class="lar la-edit"></i> @lang('Edit')</span></button>

                                        <button type="button" class="btn--no-border confirmationBtn border-0" data-question="@lang('Are you sure to remove this education?')" data-action="{{ route('influencer.remove.education', $education->id) }}" data-btn_class="btn btn--base btn--md"><span class="text--danger"><i class="las la-trash"></i> @lang('Delete')</span></button>

                                    </div>
                                </div>
                                <p>
                                    {{ __($education->institute) }}, <span>{{ __($education->country) }}</span>
                                </p>
                                <p>{{ $education->start_year }} - {{ $education->end_year }}</p>
                            </div>
                        @empty
                            <div class="justify-content-center py-3">
                                <span>@lang('No education added yet')</span>
                            </div>
                        @endforelse
                    </div>
                </div>
                {{-- end education --}}

                {{-- qualification --}}
                <div class="dashboard-card-wrap mt-0 mb-3">
                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 border-none">
                        <h5>@lang('Qualifications')</h5>
                        <button type="button" class="btn--base btn--sm qualificationBtn"> <i class="la la-plus"></i> @lang('Add New')</button>
                    </div>
                    <div>
                        @forelse (@$user->qualification??[] as $qualification)
                            <div class="education-content py-3">
                                <div class="d-flex justify-content-between align-items-center gap-3">
                                    <h6>{{ __($qualification->certificate) }}</h6>
                                    <div class="d-flex gap-sm-2 gap-1">

                                        <button type="button" class="btn--no-border editQualifyBtn border-0" data-certificate="{{ $qualification->certificate }}" data-organization="{{ $qualification->organization }}" data-year="{{ $qualification->year }}" data-summary="{{ $qualification->summary }}" data-action="{{ route('influencer.add.qualification', $qualification->id) }}"><span class="text--base"><i class="lar la-edit"></i> @lang('Edit')</span></button>

                                        <button type="button" class="btn--no-border confirmationBtn border-0" data-question="@lang('Are you sure to remove this qualification?')" data-action="{{ route('influencer.remove.qualification', $qualification->id) }}" data-btn_class="btn btn--base btn--md"><span class="text--danger"><i class="las la-trash"></i> @lang('Delete')</span></button>

                                    </div>
                                </div>
                                <p class="fw-medium my-2">
                                    {{ __($qualification->organization) }}, <span>{{ __($qualification->year) }}</span>
                                </p>
                                <p>{{ $qualification->summary }}</p>
                            </div>
                        @empty
                            <div class="justify-content-center py-3">
                                <span>@lang('No qualification added yet')</span>
                            </div>
                        @endforelse
                    </div>
                </div>
                {{-- end qualification --}}
            </div>
        </div>
    </div>
</div>

{{-- modal part --}}
{{-- lang modal --}}
<div id="languageModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Add Language')</h5>
                <span type="button" class="close btn-base btn--danger btn--sm text-white rounded" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label class="col-form-label">@lang('Name')</label>
                        <select name="name" class="form-control form--control form-select" required>
                            <option value="" selected disabled>@lang('Select One')</option>
                            @foreach ($languageData as $lang)
                                <option value="{{ $lang }}">{{__($lang) }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="from-group">
                        <label class="col-form-label fw-bold">@lang('Listening')</label>
                        <div class="d-flex justify-content-between flex-wrap">
                            <div class="form-group custom--radio">
                                <input type="radio" name="listening" id="basic-listening" value="Basic" required>
                                <label for="basic-listening">@lang('Basic')</label>
                            </div>
                            <div class="form-group custom--radio">
                                <input id="medium-listening" type="radio" name="listening" value="Medium" required>
                                <label for="medium-listening">@lang('Medium')</label>
                            </div>
                            <div class="form-group custom--radio">
                                <input id="fluent-listening" type="radio" name="listening" value="Fluent" required>
                                <label for="fluent-listening">@lang('Fluent')</label>
                            </div>
                        </div>
                    </div>
                    <div class="from-group">
                        <label class="col-form-label fw-bold">@lang('Speaking')</label>
                        <div class="d-flex justify-content-between flex-wrap">
                            <div class="form-group custom--radio">
                                <input type="radio" name="speaking" id="basic-speaking" value="Basic" required>
                                <label for="basic-speaking">@lang('Basic')</label>
                            </div>
                            <div class="form-group custom--radio">
                                <input id="medium-speaking" type="radio" name="speaking" value="Medium" required>
                                <label for="medium-speaking">@lang('Medium')</label>
                            </div>
                            <div class="form-group custom--radio">
                                <input id="fluent-speaking" type="radio" name="speaking" value="Fluent" required>
                                <label for="fluent-speaking">@lang('Fluent')</label>
                            </div>
                        </div>
                    </div>
                    <div class="from-group">
                        <label class="col-form-label fw-bold">@lang('Writing')</label>
                        <div class="d-flex justify-content-between flex-wrap">
                            <div class="form-group custom--radio">
                                <input type="radio" name="writing" id="basic-writing" value="Basic" required>
                                <label for="basic-writing">@lang('Basic')</label>
                            </div>
                            <div class="form-group custom--radio">
                                <input id="medium-writing" type="radio" name="writing" value="Medium" required>
                                <label for="medium-writing">@lang('Medium')</label>
                            </div>
                            <div class="form-group custom--radio">
                                <input id="fluent-writing" type="radio" name="writing" value="Fluent" required>
                                <label for="fluent-writing">@lang('Fluent')</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn--base">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- social link --}}
<div id="socialLinkModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Add New Social Link')</h5>
                <span type="button" class="close btn btn--base btn--danger btn--sm" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label>@lang('Icon')</label>
                        <div class="input-group">
                            <input type="text" class="form-control form--control iconPicker icon" autocomplete="off"
                                name="social_icon" required>
                            <span class="input-group-text input-group-addon" data-icon="las la-home"
                                role="iconpicker"></span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="skill" class="col-form-label">@lang('Follower\'s')</label>
                        <div class="input-group">
                            <input type="text" name="followers" class="form-control form--control" value="{{ old('followers') }}" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="skill" class="col-form-label">@lang('Url')</label>
                        <div class="input-group">
                            <input type="text" name="url" class="form-control form--control" value="{{ old('url') }}" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn--base">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- education --}}
<div id="educationModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <span type="button" class="close btn--base btn--danger btn--sm" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row gy-3">
                        <div class="form-group col-md-6">
                            <label for="skill" class="col-form-label">@lang('Country')</label>
                            <select name="country" class="form-control form--control form-select" required>
                                <option value="" selected disabled>@lang('Select Country')</option>
                                @foreach ($countries as $country)
                                    <option value="{{ $country->country }}">{{ __($country->country) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="col-form-label">@lang('University/College')</label>
                            <input type="text" name="institute" class="form-control form--control" value="{{ old('institute') }}" required>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="col-form-label">@lang('Degree')</label>
                            <input type="text" name="degree" class="form-control form--control" value="{{ old('degree') }}" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="col-form-label">@lang('Start Year')</label>
                            <select name="start_year" class="form-control form--control form-select start-year" required></select>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="col-form-label">@lang('End Year')</label>
                            <select name="end_year" class="form-control form--control form-select end-year" required></select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn--base">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- qualification --}}
<div id="qualificationModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="row gy-3">
                        <div class="form-group col-md-6">
                            <label class="col-form-label">@lang('Professional Certificate or Award')</label>
                            <input type="text" name="certificate" class="form-control form--control" value="{{ old('certificate') }}" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label class="col-form-label">@lang('Conferring Organization')</label>
                            <input type="text" name="organization" class="form-control form--control" value="{{ old('organization') }}" required>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="col-form-label">@lang('Summary')</label>
                            <textarea name="summary" class="form-control form--control">{{ old('summary') }}</textarea>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="col-form-label">@lang('Year')</label>
                            <select name="year" class="form-control form--control form-select year" required></select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn--base">@lang('Submit')</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- end qualification --}}

<x-confirmation-modal></x-confirmation-modal>
@endsection

@push('style')
    <link href="{{ asset('assets/admin/css/fontawesome-iconpicker.min.css') }}" rel="stylesheet">
@endpush

@push('script')
    <script src="{{ asset('assets/admin/js/fontawesome-iconpicker.js') }}"></script>
@endpush

@push('script')
    <script>
        (function($) {
            "use strict";

            // skill
            $('.skillBtn').on('click', function() {
                $('.noSkill').addClass('d-none');
                $("#skillContainer").append(`
                    <div class="add-skill d-flex gap-2 mb-2">
                        <input type="text" name="skills[]" class="form--control" placeholder="@lang('Enter your skill')" require>
                        <button class="btn--base btn--danger remove-btn" type="button"><i class="las la-times"></i></button>
                    </div>
                `)
            });

            $(document).on('click', '.remove-btn', function() {
                "use strict"
                $(this).closest('.add-skill').remove();
                if ($("#skillContainer").children().length == 0) {
                    $('.noSkill').removeClass('d-none');
                }
            });

            $('.editSkillbtn').on('click', function() {
                $('.skill-edit').removeClass('d-none');
                $('.influencer-skill').addClass('d-none');
            });

            $('.cancelSkillBtn').on('click', function() {
                $('.skill-edit').addClass('d-none');
                $('.influencer-skill').removeClass('d-none');
            });
            // end skill

            // language
            $('.languageBtn').on('click', function() {
                var modal = $('#languageModal');
                modal.find('form').attr('action', `{{ route('influencer.language.add') }}`);
                modal.modal('show')
            });

            $('.editLangBtn').on('click', function() {
                var modal = $('#languageModal');
                modal.find('.modal-title').text('Update Language');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('[name=name]').val($(this).data('name'));
                modal.find('select[name=label]').val($(this).data('label'));
                modal.modal('show')
            });
            // end language

            // social link
            $('.socialBtn').on('click', function() {
                var modal = $('#socialLinkModal');
                modal.find('form').attr('action', `{{ route('influencer.add.socialLink') }}`);
                modal.modal('show')
            });

            $('.editSocialBtn').on('click', function() {
                var modal = $('#socialLinkModal');
                modal.find('.modal-title').text('Update Social Link');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('[name=social_icon]').val($(this).data('social_icon'));
                modal.find('[name=url]').val($(this).data('url'));
                modal.find('[name=followers]').val($(this).data('followers'));
                modal.modal('show')
            });

            $('#socialLinkModal').on('hidden.bs.modal', function() {
                $('#socialLinkModal form')[0].reset();
            });
            // end social link

            // education
            let presentYear = new Date().getFullYear();
            let options = "";
            for (var year = presentYear; year >= 1960; year--) {
                options += `<option value="${year}">${year}</option>`;
            }

            $('.start-year').html(options)
            $('.end-year').html(options)
            $('.year').html(options)

            $('.educationBtn').on('click', function() {
                var modal = $('#educationModal');
                modal.find('.modal-title').text('Add New Education');
                modal.find('form').attr('action', `{{ route('influencer.add.education', '') }}`);
                modal.modal('show')
            });
            
            $('.editEduBtn').on('click', function() {
                var modal = $('#educationModal');
                modal.find('.modal-title').text('Update Education');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('select[name=country]').val($(this).data('country'));
                modal.find('[name=institute]').val($(this).data('institute'));
                modal.find('[name=degree]').val($(this).data('degree'));
                modal.find('select[name=start_year]').val($(this).data('start_year'));
                modal.find('select[name=end_year]').val($(this).data('end_year'));
                modal.modal('show')
            });
            // end education

            // qualification
            $('.qualificationBtn').on('click', function() {
                var modal = $('#qualificationModal');
                modal.find('.modal-title').text('Add New Qualification');
                modal.find('form').attr('action', `{{ route('influencer.add.qualification', '') }}`);
                modal.modal('show')
            });

            $('.editQualifyBtn').on('click', function() {
                var modal = $('#qualificationModal');
                modal.find('.modal-title').text('Update Qualification');
                var action = $(this).data('action');
                modal.find('form').attr('action', `${action}`);
                modal.find('[name=certificate]').val($(this).data('certificate'));
                modal.find('[name=organization]').val($(this).data('organization'));
                modal.find('[name=summary]').val($(this).data('summary'));
                modal.find('select[name=year]').val($(this).data('year'));
                modal.modal('show')
            });
            // end qualification

            $('.iconPicker').iconpicker().on('iconpickerSelected', function(e) {
                $(this).closest('.form-group').find('.iconpicker-input').val(
                    `<i class="${e.iconpickerValue}"></i>`);
            });

            $(".select2-multi-select").select2({
                dropdownParent: $('.has-select2')
            });

        })(jQuery);


    </script>
@endpush

