@extends($activeTemplate.'layouts.influencer.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="m-0">
            <div class="list-card">
                <div class="row search-dash justify-content-end mb-3">
                    <div class="col-xl-3 col-lg-5 col-md-6 col-10"> <input type="text" class="form--control" name="search_table" placeholder="@lang('Search')...">
                        <i class="las la-search"></i>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th>@lang('Title')</th>
                                    <th>@lang('Image')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Category')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($services as $item)
                                <tr>
                                    <td data-label="@lang('Title')">{{__($item->title)}}</td>
                                    <td data-label="@lang('Image')">
                                        <img src="{{getImage(getFilePath('serviceImage').'/'.@$item->image)}}" alt="@lang('serviceImage')" class="rounded img-thumbnail" style="width:60px;">
                                    </td>
                                    <td data-label="@lang('Price')">{{$general->cur_sym}}{{showAmount($item->price)}}</td>
                                    <td data-label="@lang('Category')">{{__(@$item->category->name) }}</td>
                                    <td data-label="@lang('Status')">
                                        @php
                                        echo $item->statusBadge($item->status);
                                        @endphp
                                    </td>
                                    <td data-label="@lang('Action')" class="table-dropdown">
                                        <i class="fas fa-ellipsis-v" data-bs-toggle="dropdown"></i>
                                        <ul class="dropdown-menu">
                                            <li>
                                                <a class="dropdown-item" href="{{route('influencer.service.edit',$item->id)}}">@lang('Edit')</a>
                                            </li>
                                        </ul>
                                    </td>
                                </tr>
                                @empty
                                <td class="text-muted text-center" data-label="@lang('Service Table')" colspan="100%">{{__($emptyMessage) }}</td>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-5">
                        @if ($services->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($services) }}
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>
    (function ($) {
            "use strict";

            $('.custom-table').css('padding-top', '0px');
            var tr_elements = $('.custom-table tbody tr');

            $(document).on('input', 'input[name=search_table]', function () {
                "use strict";

                var search = $(this).val().toUpperCase();
                var match = tr_elements.filter(function (idx, elem) {
                    return $(elem).text().trim().toUpperCase().indexOf(search) >= 0 ? elem : null;
                }).sort();
                var table_content = $('.custom-table tbody');
                if (match.length == 0) {
                    table_content.html('<tr><td colspan="100%" class="text-center">Data Not Found</td></tr>');
                } else {
                    table_content.html(match);
                }
            });

    })(jQuery);

</script>
@endpush

