<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title> {{ $general->siteName(__($pageTitle)) }}</title>
    @include('includes.seo')
      <!-- all css link -->
    @include($activeTemplate.'components.assetsLink.css')

     @stack('style-lib')
     @stack('style')

</head>
<body class="{{$general->rtl == 1 ? 'rtl':'ltr'}}">
    @include($activeTemplate.'components.loader')

    <div class="page-wrapper">
        @include($activeTemplate.'components.influencer.sidenav')
        <div class="main-wrapper">
            <div class="main-body-wrapper">
                @include($activeTemplate.'components.influencer.top_header')
                @yield('content')
            </div>
        </div>
    </div>

    <!-- all js link -->
    @include($activeTemplate.'components.assetsLink.js')
    @stack('script')
    @stack('script-lib')
    @include('includes.plugins')
    @include('includes.notify')

<script>
    (function ($) {
        "use strict";

        if ($(".trumEdit")[0]) {
            ClassicEditor
                .create(document.querySelector('.trumEdit'))
                .then(editor => {
                    window.editor = editor;
                });
        }

        $(".langSel").on("change", function() {
            window.location.href = "{{route('home')}}/change/"+$(this).val() ;
        });

        $('.policy').on('click',function(){
            $.get('{{route('cookie.accept')}}', function(response){
                $('.cookies-card').addClass('d-none');
            });
        });

        setTimeout(function(){
            $('.cookies-card').removeClass('hide')
        },2000);

    })(jQuery);
</script>

</body>
</html>
