@php
    $workingProcess = getContent('working_process.content', true);
    $workingProcessElement = getContent('working_process.element', false,3);
@endphp
<!-- ====================  Works Start ==================== -->
<section class="works py-80">
    <div class="shape">
        <img src="{{ asset($activeTemplateTrue .'images/shape/shape2.png') }}" alt="@lang('shape')">
    </div>
    <div class="shape2">
        <img src="{{ asset($activeTemplateTrue .'images/shape/shape3.png') }}" alt="@lang('shape')">
    </div>
    <div class="container">
        <div class="title">
            <h4>{{__(@$workingProcess->data_values->heading)}}</h4>
            <p>{{__(@$workingProcess->data_values->sub_heading)}}</p>
        </div>
        <div class="row gy-4 mt-2 justify-content-center">
            @foreach ($workingProcessElement as $key=>$item)
            <div class="col-lg-4 col-md-6 col-12">
                <div class="card">
                    <div class="d-flex">
                        <div>
                            <h3>0{{$key+1}}</h3>
                            <div class="bg"></div>
                        </div>
                        <div class="hr"></div>
                    </div>
                    <div class="content">
                        <h5>{{__(@$item->data_values->title)}}</h5>
                        <p>
                            @if (strlen(__(@$item->data_values->short_description)) >80)
                            {{ substr(__(@$item->data_values->short_description), 0, 80) . '...' }}
                            @else
                            {{__(@$item->data_values->short_description) }}
                            @endif
                        </p>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!-- ====================  Works End ==================== -->
