@extends($activeTemplate.'layouts.client.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="body-area">
                    <h5>@lang('Influencer Information')</h5>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Name')</span>
                            <span>{{__(@$hiring->influencer->fullname) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Email')</span>
                            <span>{{@$hiring->influencer->email}}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Country')</span>
                            <span>{{__(@$hiring->influencer->address->country) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Member Since')</span>
                            <span>{{ showDateTime($hiring->influencer->created_at) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Order Complted')</span>
                            <span>{{@$hiring->influencer->completed_order}}</span>
                        </li>
                        @if(@$hiring->influencer)
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Influencer Profile')</span>
                            <span>
                                <a href="{{ route('influencer.profile', [slug($hiring->influencer->username), $hiring->influencer_id]) }}"
                                    class="btn--base btn--sm" target="_blank"><i class="las la-external-link-alt"></i></a>
                            </span>
                        </li>
                        @endif
                    </ul>
                    @if ($hiring->status == 3)
                    <div class="mt-4">
                        <h5>@lang('Take Action')</h5>
                        <div class="d-flex flex-wrap gap-2">
                            <button type="button" class="btn--base btn--danger btn--sm reportBtn" data-id="{{$hiring->id }}">
                                <i class="las la-gavel"></i> @lang('Report to Admin')
                            </button>

                            <button type="button" class="btn--success btn--base btn--sm confirmationBtn"
                                data-action="{{ route('user.hiring.complete.status', $hiring->id) }}"
                                data-question="@lang('Are you sure to complete this hiring?')">
                                <i class="las la-check-double"></i> @lang('Complete')
                            </button>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            <div class="col-lg-6">
                <div class="body-area">
                    <h5>@lang('Hiring Information')</h5>
                    <ul class="list-group">
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Title')</span>
                            <span>{{$hiring->title}}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Delivery Date')</span>
                            <span>{{ showDateTime($hiring->delivery_date) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Amount')</span>
                            <span>{{ $general->cur_sym }}{{ showAmount($hiring->amount) }}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Hiring No')</span>
                            <span>{{$hiring->hiring_no}}</span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Status')</span>
                            <span> @php echo $hiring->statusBadge($hiring->status) @endphp </span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Description')</span>
                            <button class="btn--base btn--sm  descriptionBtn"
                                data-description="{{ $hiring->description }}"><i class="las la-eye"></i>
                            </button>
                        </li>
                        @if ($hiring->status == 4)
                        <li class="list-group-item d-flex justify-content-between flex-wrap">
                            <span class="fw-bold">@lang('Reason of Report')</span>
                            <button class="btn--base btn--sm reasonBtn"
                                data-reason="{{ $hiring->reason }}"><i class="las la-gavel"></i>
                            </button>
                        </li>
                        @endif
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- report modal --}}
<div id="reportModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Report to Admin')</h5>
                <span type="button" class="close btn--base btn--danger btn--sm" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <form action="" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group report-reason">
                        <label class="form-label">@lang('Reason')</label>
                        <textarea name="reason" class="form-control form--control">{{ old('reason') }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn--dark btn--md" data-bs-dismiss="modal">@lang('No')</button>
                    <button type="submit" class="btn btn--base btn--md">@lang('Yes')</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- description modal --}}
<div id="descriptionModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"></h5>
                <span type="button" class="close btn--base btn--danger btn--sm" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <p class="description"></p>
            </div>
        </div>
    </div>
</div>
<x-confirmation-modal></x-confirmation-modal>

@endsection

@push('script')
<script>
    (function($) {
            "use strict";

            $('.reportBtn').on('click', function() {
                var modal = $('#reportModal');
                let id = $(this).data('id');
                modal.find('form').attr('action', `{{ route('user.hiring.report.status', '') }}/${id}`);
                modal.modal('show');
            });

            $('.descriptionBtn').on('click',function () {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Description')
                modal.find('.description').html($(this).data('description'));
                modal.modal('show');
            });

            $('.reasonBtn').on('click',function () {
                var modal = $("#descriptionModal");
                modal.find('.modal-title').text('Reason of Report')
                modal.find('.description').text($(this).data('reason'));
                modal.modal('show');
            });

            
        })(jQuery);
</script>
@endpush
