@extends($activeTemplate.'layouts.client.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="body-area">
            <div class="form-body">
                <div class="row g-3">
                    <div class="col-lg-12">
                        <div class="review-box">
                            <form action="{{route('user.review.influencer.store')}}" method="post" class="mt-3">
                                @csrf
                                <input type="hidden" name="star" id="rating" value="0">
                                <input type="hidden" name="hiring_id" value="{{$hiring->id}}">
                                <h5>@lang('Write a review')</h5>
                                <div class="d-flex align-items-center star rating-wrap rating-stars mb-3 text--base">
                                    <i class="far fa-star" data-rating="1"></i>
                                    <i class="far fa-star" data-rating="2"></i>
                                    <i class="far fa-star" data-rating="3"></i>
                                    <i class="far fa-star" data-rating="4"></i>
                                    <i class="far fa-star" data-rating="5"></i>
                                </div>
                                <textarea class="form--control" name="review" placeholder="Write Your Review"></textarea>
                                <button type="submit" class="btn--base mt-2">@lang('Submit')</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script>

        // rating set
        $(document).ready(function() {
            'use strict'

            var initialRating = parseInt($('#rating').val());
                if (initialRating > 0) {
                    updateStars(initialRating);
            }

            $('.rating-stars i').on('click', function() {
                var rating = parseInt($(this).data('rating'));
                $('#rating').val(rating);
                updateStars(rating);
            });

            $('#rating').on('input', function() {
                var rating = $(this).val();
                updateStars(rating);
            });


            function updateStars(rating) {
                var stars = $('.rating-stars i');
                stars.removeClass('fas').addClass('far');
                stars.each(function(index) {
                    if (index < rating) {
                        $(this).removeClass('far').addClass('fas');
                    }
                });
            }

        });
        // end rating set
</script>
@endpush

