@extends($activeTemplate.'layouts.client.master')
@section('content')

    <div class="body-wrapper">
        <div class="table-content">
            <div class="m-0">
                <div class="list-card">
                    <div class="row search-dash justify-content-end mb-3">
                        <div class="col-xl-3 col-lg-5 col-md-6 col-10"> <input type="text" class="form--control" name="search_table" placeholder="@lang('Search')...">
                            <i class="las la-search"></i>
                        </div>
                    </div>
                    <div class="row justify-content-center">
                        <div class="col-xl-12">
                            <table class="custom-table">
                                <thead>
                                    <tr>
                                        <th>@lang('Service Name')</th>
                                        <th>@lang('Time')</th>
                                        <th>@lang('Action')</th>
                                    </tr>
                                </thead>
                                <tbody>
                                     @forelse ($wishlists as $item)
                                        <tr>
                                            <td data-label="@lang('Service Name')"><a href="{{ route('service.details', [slug($item->service->title), $item->service->id]) }}" target="__blank" class="text--base">{{__($item->service->title)}}</a></td>
                                            <td data-label="@lang('Time')">{{showDateTime($item->created_at)}}</td>
                                            <td data-label="@lang('Action')" class="table-dropdown">
                                                <i class="fas fa-ellipsis-v" data-bs-toggle="dropdown"></i>
                                                <ul class="dropdown-menu">
                                                    <li>
                                                        <a class="dropdown-item deletModalBtn" data-id="{{$item->id}}" href="javascript:void(0)">@lang('Remove')</a>
                                                    </li>
                                                </ul>
                                            </td>
                                        </tr>
                                        @empty
                                        <td class="text-muted text-center" colspan="100%" data-label="@lang('Wishlist Table')">{{__($emptyMessage) }}</td>
                                     @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-5">
                            @if ($wishlists->hasPages())
                            <div class="py-4">
                                {{ paginateLinks($wishlists) }}
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Delete Modal --}}
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="editModalLabel">@lang('Delete Confirmation!')</h4>
                    <button type="button" class="close btn--base btn--danger btn--sm" data-bs-dismiss="modal" aria-label="Close"><i
                            class="las la-times"></i>
                    </button>
                </div>
                <form action="{{route('user.wishlist.remove')}}" method="get" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <div class="row">
                        <p>@lang('are you sure delete this wishlist?')</p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn--base btn--danger btn--sm">@lang('Remove')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection

@push('script')
<script>
    (function ($) {
            "use strict";

            $('.custom-table').css('padding-top', '0px');
            var tr_elements = $('.custom-table tbody tr');

            $(document).on('input', 'input[name=search_table]', function () {
                "use strict";

                var search = $(this).val().toUpperCase();
                var match = tr_elements.filter(function (idx, elem) {
                    return $(elem).text().trim().toUpperCase().indexOf(search) >= 0 ? elem : null;
                }).sort();
                var table_content = $('.custom-table tbody');
                if (match.length == 0) {
                    table_content.html('<tr><td colspan="100%" class="text-center">Data Not Found</td></tr>');
                } else {
                    table_content.html(match);
                }
            });

            $('.deletModalBtn').on('click', function () {
                var modal = $('#deleteModal');
                var id = $(this).data('id');
                modal.find('input[name=id]').val(id);
                modal.modal('show');
            });

    })(jQuery);

</script>
@endpush
